<?php

/**
 * Test do_action() and related functions
 *
 * @group hooks
 */

class Test_StockHandler extends TW_External_Stock_Handler {

    private $stockQuantity = 10;
    protected $maxDelayBeforeUpdateInSeconds = 900;

    public function __construct($stockQuantity)
    {
        $this->stockQuantity = $stockQuantity;
    }

    public function canHandle(WC_Product $product)
    {
        if($product->get_supplier_data('supplier_name') !== null && strtolower($product->get_supplier_data('supplier_name')) == 'test') {
            return true;
       }
       return false;
    }

    /**
     * @param [WC_Product]$products
     * @param (bool)$forceRefresh
     * @return array($totalStocks, $refeshedStock) 
     */
    public function getProductStocks($products, $forceRefresh = true)
    {
        return $this->stockQuantity;
    }

    /**
     * @param [int]$productIds
     * @return array
     */
    private function _retrieveProductStocks($productIds)
    {
    }

    public function blockProductsReservation($products)
    {
    }

    public function releaseProductsReservation($products)
    {
    }
}
