# E2E Tests

End-To-End (E2E) tests for WordPress.


## Running the tests

The e2e tests require a production-like environment to run. By default, they will assume an environment is available at `http://localhost:8889`, with username `admin` and password `password`.

If you don't already have an environment ready, you can set one up by following [these instructions](https://github.com/WordPress/wordpress-develop/blob/master/README.md).

Then you can launch the tests by running:

```
npm run test:e2e
```

which will run the test suite using a headless browser.

If your environment has a different url, username or password to the default, you can provide the base URL, username and password like this:

```
WP_BASE_URL=http://mycustomurl WP_USERNAME=username WP_PASSWORD=password npm run test:e2e
```
**DO NOT run these tests in an actual production environment, as they will delete all your content.**

For debugging purposes, you might want to follow the test visually. You can do so by running the tests in an interactive mode:

```
npm run test:e2e -- --ui
```

[UI Mode](https://playwright.dev/docs/test-ui-mode) let's you explore, run and debug tests with a time travel experience complete with watch mode.
All test files are loaded into the testing sidebar where you can expand each file and describe block to individually run, view, watch and debug each test.

You can also run a single test file separately:

```
npm run test:e2e tests/e2e/specs/hello.test.js
```


## Documentation

* Block Editor Handbook end to end testing overview: https://developer.wordpress.org/block-editor/contributors/code/testing-overview/#end-to-end-testing

* Gutenberg e2e-test-utils-playwright package API docs: https://github.com/WordPress/gutenberg/tree/trunk/packages/e2e-test-utils-playwright

* Playwright API docs: https://playwright.dev/docs (the version we are using is indicated in the `@wordpress/scripts` package: https://github.com/WordPress/gutenberg/blob/trunk/packages/scripts/package.json)
