/**
 * Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Customizer preview reload changes asynchronously.
 * Things like site title and description changes.
 */

( function( $ ) {
	// Site title and description.
	wp.customize( 'blogname', function( value ) {
		value.bind( function( to ) {
			$( '.site-title' ).text( to );
		} );
	} );
	wp.customize( 'blogdescription', function( value ) {
		value.bind( function( to ) {
			$( '.site-description' ).text( to );
		} );
	} );
	// Header text color.
	wp.customize( 'header_textcolor', function( value ) {
		value.bind( function( to ) {
			if ( 'blank' === to ) {
				if ( 'remove-header' === wp.customize.instance( 'header_image' ).get() ) {
					$( '.home-link' ).css( 'min-height', '0' );
				}
				$( '.site-title, .site-description' ).css( {
					'clip-path': 'inset(50%)',
					'position': 'absolute'
				} );
			} else {
				$( '.home-link' ).css( 'min-height', '230px' );
				$( '.site-title, .site-description' ).css( {
					'clip-path': 'none',
					'color': to,
					'position': 'relative'
				} );
			}
		} );
	} );
} )( jQuery );
