<?php
defined( 'ABSPATH' ) || exit;

if(!function_exists('tw_enqueue_style')){
    function tw_enqueue_style($handle, $src, $deps = [], $version = null, $media = 'all'){
        if($version === null) {
            $version = rand(1,99999);
        }
        
        wp_enqueue_style(
            $handle,
            $src,
            $deps,
            $version,
            $media
        );
    }
}

if(!function_exists('tw_enqueue_script')){
    function tw_enqueue_script($handle, $src, $deps = [], $version = null, $args = []){
        if($version === null) {
            $version = rand(1,99999);
        }

        wp_enqueue_script(
            $handle,
            $src,
            $deps,
            $version,
            true
        );
    }
}

if(!function_exists('tw_pdo_connection')){
    function tw_pdo_connection() {
        global $wpdb;
        $host_data = $wpdb->parse_db_host(DB_HOST);
	
        if (is_array($host_data)) {
            list($host, $port, $socket, $is_ipv6) = $host_data;
        } else {
            // Redacted. Throw an error or something 
        }

        // Wrap the IPv6 host in braces as required
        if ($is_ipv6 && extension_loaded('mysqlnd')) {
            $host = "[$host]";
        }

        // Generate either a socket connection string or TCP connection string
        if (isset($socket)) {
            $connection_str = 'mysql:unix_socket=' . $socket . ';dbname=' . DB_NAME . ';charset=' . DB_CHARSET;
        } else {
            $connection_str = 'mysql:host=' . $host . ';dbname=' . DB_NAME . ';charset=' . DB_CHARSET;

            if (isset($port)) {
                $connection_str .= ';port=' . $port;
            }
        }

        // Open the connection
        $pdo = new PDO($connection_str, DB_USER, DB_PASSWORD);
        return $pdo;
    }
}

if(!function_exists('tw_user_has_role')){
    function tw_user_has_role($role) {
        $has_role = false;
        $user = wp_get_current_user();
        
        if ( in_array($role, (array) $user->roles ) ) {
            $has_role = true;
        }
        return $has_role;
    }
}

if(!function_exists('tw_parse_url')){
    function tw_parse_url($url) {
        $script_name = "";
        $params = [];
        $is_admin = is_admin();
        $post_edition = false;
        $edited_post_type = null;
        
        $url_components = parse_url($url);
        if(isset($url_components['query'])){
            parse_str($url_components['query'], $params);
        }
    
        $path = explode('/', $url_components['path']);
        if(count($path) > 0) {
            $path = array_filter($path, function($item){
                return $item !== null && trim($item) != "";
            });
            $path = array_values($path);
    
            if(count($path) > 0) {
                $script_name = $path[count($path) - 1];
                if(strpos($script_name, '/') === 0) {
                    $script_name = substr($script_name, 1);
                }
            }
        }
    
        $post_edition = in_array($script_name, array('post-new.php', 'post.php'));
        if($post_edition) {
            $edited_post_type = isset($params['post_type']) ? $params['post_type'] : 'post';
        }
    
        if($post_edition && isset($params['post'])){
            $post = get_post($params['post']);
            $edited_post_type = get_post_type($post);
        }
        
        $comment_edition = in_array($script_name, array('comment.php'));
    
        $term_edition = in_array($script_name, array('term.php', 'edit-tags.php', 'edit-tag-form.php'));
        $edited_term_taxonomy = null;
        if(isset($params['taxonomy'])){
            $edited_term_taxonomy = $params['taxonomy'];
        }
    
        $url_slug = null;
        if(get_option('permalink_structure') == '/%postname%/') {
            $url_slug = $_SERVER['REQUEST_URI'];
            if($url_slug[0] == "/") {
                $url_slug = substr($url_slug, 1);
            }
            
            if(strlen($url_slug) >= 1 && $url_slug[strlen($url_slug) - 1] == '/') {
                $url_slug = substr($url_slug, 0, strlen($url_slug) - 1);
            }
    
            $query_args_pos = strpos($url_slug, '?');
            if($query_args_pos !== false) {
                $url_slug = substr($url_slug, 0, $query_args_pos);
            }
    
            if(strlen($url_slug) > 1 && $url_slug[strlen($url_slug) - 1] == '/') {
                $url_slug = substr($url_slug, 0, strlen($url_slug) - 1);
            }
        }
    
        $user_edition = in_array($script_name, array('profile.php', 'user-edit.php', 'user-new.php'));
        return array(
            'script_name' => $script_name,
            'params' => $params,
            'is_admin' => $is_admin,
            'post_edition' => $post_edition,
            'comment_edition' => $comment_edition,
            'edited_post_type' => $edited_post_type,
            'term_edition' => $term_edition,
            'edited_term_taxonomy' => $edited_term_taxonomy,
            'user_edition' => $user_edition,
            'url_slug' => $url_slug
        );
    }
}

if(!function_exists('tw_add_flash_notice')){
    function tw_add_flash_notice( $notice = "", $type = "warning", $dismissible = true ) {

        // Here we return the notices saved on our option, if there are not notices, then an empty array is returned
        $notices = get_option( "tw_flash_notices", array() );
     
        $dismissible_text = ( $dismissible ) ? "is-dismissible" : "";
     
        // We add our new notice.
        array_push( $notices, array( 
                "notice" => $notice, 
                "type" => $type, 
                "dismissible" => $dismissible_text
            ) );
     
        // Then we update the option with our notices array
        update_option("tw_flash_notices", $notices );
    }
     
    /**
     * Function executed when the 'admin_notices' action is called, here we check if there are notices on
     * our database and display them, after that, we remove the option to prevent notices being displayed forever.
     * @return void
     */
     
    function tw_display_flash_notices() {
        $notices = get_option( "tw_flash_notices", array() );
         
        // Iterate through our notices to be displayed and print them.
        foreach ( $notices as $notice ) {
            printf('<div class="notice notice-%1$s %2$s"><p>%3$s</p></div>',
                $notice['type'],
                $notice['dismissible'],
                $notice['notice']
            );
        }
     
        // Now we reset our options to prevent notices being displayed forever.
        if( ! empty( $notices ) ) {
            delete_option( "tw_flash_notices", array() );
        }
    }
}

if(!function_exists('tw_get_taxonomy_values')){
    function tw_get_taxonomy_values($taxonomyName, $format="FULL")
    {
        global $wpdb;
        $results = $wpdb->get_results(
            $wpdb->prepare(
                "SELECT wpt.name, wpt.slug, wtt.taxonomy, wtt.term_id
                from wp_term_taxonomy wtt
                inner join wp_terms wpt on (wpt.term_id = wtt.term_taxonomy_id)
                where lower(wtt.taxonomy) = %s", 
                ['pa_' . strtolower($taxonomyName)]
            ),
            ARRAY_N
        );

        if($format == "FULL") {
            return $results;
        } else {
            $terms = [];
            foreach($results as $term => $detail) {
                $terms[] = strtolower($term);
            }
            return $terms;
        }
    }
}

if(!function_exists('tw_prepare_in')){
    function tw_prepare_in ( $values ) {
        return implode( ',', array_map( function ( $value ) {
            global $wpdb;
    
            // Use the official prepare() function to sanitize the value.
            return $wpdb->prepare( '%s', $value );
        }, $values ) );
    };
}

if(!function_exists('tw_get_block_template_file')){
    function tw_get_block_template_file($file_path, $post_type, $template_type = 'wp_template', $template_path = 'templates'){
        $templateFiles = [];
        if(!file_exists($file_path)){
            return [];
        }

        $theme_slug = get_stylesheet();
        $template_slug  = substr(
            $file_path,
            // Starting position of slug.
            strpos( $file_path, $template_path . DIRECTORY_SEPARATOR ) + 1 + strlen($template_path),
            // Subtract ending '.php'.
            -4
        );

        $templateItem = [
            'slug'  => $template_slug,
            'path'  => $file_path,
            'theme' => $theme_slug,
            'type'  => $template_type,
        ];
        
        if ('wp_template_part' === $template_type) {
            $templateItem = _add_block_template_part_area_info($templateItem);
            $template_files[$template_slug] = $templateItem;
        }

        if('wp_template' === $template_type) {
            $templateItem = _add_block_template_info($templateItem);
            $is_custom = true;

            if (
                ! $post_type ||
                ( $post_type && isset( $templateItem['postTypes'] ) && in_array( $post_type, $templateItem['postTypes'], true ) )
            ) {
                $template_files[ $template_slug ] = $templateItem;
            }

            // The custom templates with no associated post types are available for all post types.
            if ( $post_type && !isset( $candidate['postTypes'] ) && $is_custom ) {
                $template_files[ $template_slug ] = $templateItem;
            }
        }
        
        return array_values($template_files);
    }
}

if(!function_exists("tw_register_inline_template")){
    function tw_register_inline_template($tplSlug, $tplContent)
    {
        if(!isset($GLOBALS['tw_inline_model'])){
            $GLOBALS['tw_inline_model'] = [];
        }

        $GLOBALS['tw_inline_model'][$tplSlug] = $tplContent;
    }
}

if(!function_exists('tw_custom_url')){
    function tw_custom_url($url_regex, $params, $priority = PHP_INT_MAX) {
        $slugify = new Cocur\Slugify\Slugify();
        $page_key = $slugify->slugify($url_regex);

        $GLOBALS['tw_custom_url_' . $page_key] = [
            'url_regex' => $url_regex,
            'params' => $params
        ];

        add_filter('option_rewrite_rules',  function($value) use ($url_regex, $params, $page_key){
            $url_params = [];
            $redirectedPage = 'index.php?tw_custom_url=' . $page_key;

            $index = 1;
            foreach($params as  $key) {
                $redirectedPage .= '&' . $key .'=$matches[' . $index . ']';
                $index++;
            }
            
            if(is_array($value)){
                $value = [$url_regex => $redirectedPage] + $value;
            }
            return $value;
        }, $priority);

        add_filter('query_vars', function($query_vars) use ($params){
            if(!in_array('tw_custom_url', $query_vars)){
                $query_vars[] = 'tw_custom_url';
            }

            foreach($params as $key) {
                if(!in_array($key, $query_vars)){
                    $query_vars[] = $key;
                }
            }
            return $query_vars;
        }, $priority);

        if(!isset($GLOBALS['tw_custom_url_parse_query']) || $GLOBALS['tw_custom_url_parse_query'] === false) {
            add_filter('parse_query', function(WP_Query $query){
                if(isset($query->query_vars['tw_custom_url'])) {
                    $query->is_home = false;
                    $query->is_singular = true;
                }
            }, $priority);
        }
        $GLOBALS['tw_custom_url_parse_query'] = true;

        if(!isset($GLOBALS['tw_custom_url_pre_query']) || $GLOBALS['tw_custom_url_pre_query'] === false) {
            add_filter('posts_pre_query', function($posts, WP_Query $query){
                if(isset($query->query_vars['tw_custom_url'])) {
                    $newPosts = [];
                    $postData = new stdClass();
                    $newPosts[] = new WP_Post($postData);
                    $posts = $newPosts;
                }
                return $posts;
            }, $priority, 2);
        }
        $GLOBALS['tw_custom_url_pre_query'] = true;
    }
}

if (!function_exists('tw_custom_page') ) {
    function tw_custom_page($url_regex, $params, $page_path = null, $page_callback = null, $priority = PHP_INT_MAX) {
        $slugify = new Cocur\Slugify\Slugify();
        $page_key = $slugify->slugify($url_regex);

        $GLOBALS['tw_custom_page_' . $page_key] = [
            'url_regex' => $url_regex,
            'params' => $params,
            'page_path' => $page_path,
            'page_callback' => $page_callback
        ];

        add_filter('option_rewrite_rules',  function($value) use ($url_regex, $params, $page_key){
            $url_params = [];
            $redirectedPage = 'index.php?tw_custom_page=' . $page_key;

            $index = 1;
            foreach($params as  $key) {
                $redirectedPage .= '&' . $key .'=$matches[' . $index . ']';
                $index++;
            }
            
            if(is_array($value)){
                $value = [$url_regex => $redirectedPage] + $value;
            }
            return $value;
        }, $priority);

        add_filter('query_vars', function($query_vars) use ($params){
            if(!in_array('tw_custom_page', $query_vars)){
                $query_vars[] = 'tw_custom_page';
            }

            foreach($params as $key) {
                if(!in_array($key, $query_vars)){
                    $query_vars[] = $key;
                }
            }
            return $query_vars;
        }, $priority);

        
        if(!isset($GLOBALS['tw_custom_page_template_included']) || $GLOBALS['tw_custom_page_template_included'] === false) {
            add_filter('template_include', function( $template ){
                if (get_query_var('tw_custom_page') == false || get_query_var('tw_custom_page') == '' ) {
                    return $template;
                }

                $page_key = get_query_var('tw_custom_page');
                $page_params = $GLOBALS['tw_custom_page_' . $page_key];

                if($page_params['page_path'] !== null) {
                    return $page_params['page_path'];
                } else {
                    return __DIR__ . '/virtual_page.php';
                }
            }, $priority);
        }
        $GLOBALS['tw_custom_page_template_included'] = true;

        if(!isset($GLOBALS['tw_custom_page_callback_included']) || $GLOBALS['tw_custom_page_callback_included'] === false) {
            add_action('tw_virtual_page_callback', function(){
                $queried_page_key = get_query_var('tw_custom_page', null);

                if($queried_page_key !== null) {
                    $page_params = $GLOBALS['tw_custom_page_' . $queried_page_key];
                    if($page_params['page_callback'] !== null) {
                        $page_params['page_callback']();
                    }
                }
            });
        }
        $GLOBALS['tw_custom_page_callback_included'] = true;
    }
}

/*
add_filter('posts_search', function($search_query, WP_Query $query){
    global $wpdb;
    $search_parameters = [];
    $query_vars = $query->query_vars;

    if(isset($query_vars['search_parameters_override']) 
        && is_array($query_vars['search_parameters_override'])
        && count($query_vars['search_parameters_override']) > 0
    ){
        if(count($query_vars['search_parameters_override']) == 1) {
            $search_parameters[] = $query_vars['search_parameters_override'][0];
        } else {
            $search_parameters[] = $query_vars['search_parameters_override'];
        }
    }

    if(count($search_parameters) > 0) {
        $parsed_search_query = " AND ";

        if(count($search_parameters) > 1) {
            $parsed_search_query .= "(";
        }

        for($i=0;$i<count($search_parameters); $i++) {
            $param = $search_parameters[$i];
            if($i>0) {
                $parsed_search_query .= isset($param['condition']) ?  ' ' . $param['condition'] . ' ' : ' AND ';
            }

            $paramName = $param['column'];
            if(strstr($paramName, '.') === false) {
                $paramName = $wpdb->posts . "." . $paramName;
            }

            $parsed_search_query .= $paramName . ' ' . $param['criteria'] . ' ';
            if(strtoupper($param['criteria']) == 'LIKE') {
                $parsed_search_query .= '"%' . $param['term'] . '%"';
            } else {
                $parsed_search_query .=  $param['term'];
            }
        }

        if(count($search_parameters) > 1) {
            $parsed_search_query .= ")";
        }
        $search_query = $parsed_search_query;
    }

    return $search_query;
}, PHP_INT_MAX, 2);
*/