<?php
/**
 * Plugin Name: TW Core
 * Description: Enable TW customisation
 * Version:     1.0.0
 * Author:      techniway
 * Text Domain: tw
 */

use Dom\Document;
use Monolog\Logger;
use Monolog\Handler\StreamHandler;
use PhpParser\Node\Expr\Exit_;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if(!function_exists("tw_is_test_environment")) {
    function tw_is_test_environment() {
        return defined('ABSPATH') && preg_match('/plugins\/tw-test/', ABSPATH);
    }
}

$includePath = __DIR__;
if(tw_is_test_environment()){
	$includePath = strpos(ABSPATH, 'wp-content');
	$includePath = substr(ABSPATH, 0, $includePath) . '/wp-content/plugins/tw-core';
}

//attention au debug.log
require_once $includePath . '/vendor/autoload.php';
require_once $includePath . '/utility.php';
require_once $includePath . '/wordpress_utility.php';
require_once $includePath . '/ecommerce_utility.php';
require_once $includePath . '/tw_core_enum.php';
require_once $includePath . '/theme_variables_loader.php';

require_once $includePath . '/classes/tw_node.php';
require_once $includePath . '/classes/tw_session.php';
require_once $includePath . '/classes/tw_stylesheet.php';
require_once $includePath . '/classes/tw_template_parser.php';
require_once $includePath . '/classes/tw_metabox.php';
require_once $includePath . '/classes/tw_rest_search_controller.php';
require_once $includePath . '/classes/tw_core_exception.php';
require_once $includePath . '/classes/tw_attributes_trait.php';
require_once $includePath . '/classes/tw_variation_trait.php';
require_once $includePath . '/classes/tw_supplier_trait.php';
require_once $includePath . '/classes/tw_delivery_trait.php';
require_once $includePath . '/classes/tw_stock_management_trait.php';
require_once $includePath . '/classes/tw_shipping_handler.php';
require_once $includePath . '/classes/tw_shipping.php';
require_once $includePath . '/classes/tw_shipping_detail.php';
require_once $includePath . '/classes/tw_external_stock_handler.php';
require_once $includePath . '/classes/tw_supercache_rest_preload.php';
require_once $includePath . '/classes/tw_factory.php';

require_once $includePath . '/manager/tw_external_stock_manager.php';
require_once $includePath . '/manager/tw_supercache_linked_content_manager.php';
require_once $includePath . '/manager/tw_shipping_manager.php';
require_once $includePath . '/manager/tw_task_manager.php';

if(tw_is_plugin_active('woocommerce/woocommerce.php')) {
	require_once $includePath . '/classes/tw_shipping_controller.php';
}

tw_include_files($includePath . '/repository', 'include', function($classname){
	TW_Factory::getInstance()->instantiateClass($classname);
});
tw_include_files($includePath . '/includes');
tw_include_files($includePath . '/commands');

$tw_site_override_path =  dirname($includePath, 2) . '/site-override';
if(file_exists($tw_site_override_path)){
	require_once $tw_site_override_path . '/site-override.php';
}

$logger = new Logger("debug ");
if(!file_exists(ABSPATH . 'tw_debug.log')){
	touch(ABSPATH . 'tw_debug.log');
	chmod(ABSPATH . 'tw_debug.log', 0622);
}
$stream_handler = new StreamHandler(ABSPATH . 'tw_debug.log');
$logger->pushHandler($stream_handler);

$GLOBALS['tw_logger'] = $logger;
$GLOBALS['tw_session'] = new TW_Session();
$GLOBALS['tw_registered_filters'] = [];
$GLOBALS['tw_registered_actions'] = [];
$GLOBALS['supported_products_type'] = [
	'simple' => [
		'initial_classname' => 'WC_Product_Simple',
		'classname' => 'TW_Product_Simple',
		'path'	=> __DIR__ . '/classes/tw_product_simple.php',
		'name' => 'Simple product'
	],
	'simple-with-variations' => [
		'initial_classname'	=> 'WC_Product_Simple_With_Variations',
		'classname' => 'TW_Product_Variable',
		'path'	=> __DIR__ . '/classes/tw_product_variable.php',
		'name' => 'Variable product',
	]
];

add_action('init', function(){	
	tw_custom_page(
        '^tw-core/test',
        [],
        null,
        function() {
			$weeklyProductBoughtQuantity = TW_Factory::getInstance()->getClass(TW_Product_Repository::class)->getWeeklyBoughtQuantity(431);
			
			global $wp_query;
			$productQuery = new WC_Product_Query(array(
				'limit' => -1,
				'category' => array('vetement'),
			));

			$queryVars = $productQuery->get_query_vars();

			$productQuery->get_products();

			$productDataStore = new WC_Product_Data_Store_CPT();
			$productDataStoreReflector = new ReflectionMethod($productDataStore, 'get_wp_query_args');
			$productDataStoreReflector->setAccessible(true);
			$queryVars = $productDataStoreReflector->invoke($productDataStore, $queryVars);
			var_dump($queryVars);
			var_dump($queryVars['tax_query']);

			$previousQuery = $wp_query;

			/*
			$wp_query = new WP_Query(array(
'posts_per_page' => -1,
'order' => 'DESC',
'orderby' => 'date',
'fields' => 'objects',
'post_type' => 'product',
'category' => array('vetement'),
'post_status' => array('draft', 'pending', 'private', 'publish'),
'tax_query' => array(
	array(
		'taxonomy' => 'product_type',
		'field' => 'slug',
		'terms' => array(
			'external',
			'simple',
			'simple-with-variations'
		),
		'taxonomy' => 'product_cat',
		'field' => 'slug',
		'terms' => array('vetement')
	)
)
));
*/

			
			$wp_query = new WP_Query(array(
'posts_per_page' => -1,
'paginate' => false,
'order' => 'DESC',
'orderby' => 'date',
'fields' => 'objects',
'post_type' => 'product',
'category' => array('vetement'),
'post_status' => array('draft', 'pending', 'private', 'publish'),
'tax_query' => array(
	array(
		'taxonomy' => 'product_type',
		'field' => 'slug',
		'terms' => array(
			'external',
			'simple',
			'simple-with-variations'
		),
	),
	array(
		'taxonomy' => 'product_cat',
		'field' => 'slug',
		'terms' => array('vetement')
	)
)
));

			$links = paginate_links(array(
				'type' => 'array',
				'current' => 5,
				'total' => 30,
				'prev_next' => true,
				'show_all' => false
			));
			var_dump($links);
			die;

			$wp_query = $previousQuery;
			//$products = $productQuery->get_products();

			/*
			var_dump($products);
			die;
			*/

			var_dump(date('d F Y'));
			var_dump(time());
			var_dump(time() - strtotime(date('d F Y')));
			die;
			
			/*
			var_dump( time() - ((time() - strtotime(date('d F Y'))) % $interval);
			var_dump(get_permalink(638));
			die;
			*/

			var_dump(\Elementor\Plugin::instance()->documents->get(675)->get_permalink());
			die;

			$test = array(
				array(
					'name' => 'element1',
					'toto' => 'lolo'
				),
				array(
					'name' => 'element2',
					'child' => array(
						array(
							'name' => 'element3',
							'child' => array(
								'name' => 'element4',
								'child' => array(
									'name' => 'element5'
								)
							)
						),
						array(
							'name' => 'element6',
							'child' => array(
								'name' => 'element7',
								'child' => array(
									'name' => 'element9'
								)
							)
						)
					)
				),
				array(
					'name' => 'element8',
				)
			);

			/*
			$test = array(
					'element1',
					'element2' => array(
						'child' => array(
							'element3',
							'element4' => array(
								'child' => array(
									'element5' => array(
										'child' => 'element6'
									)
								)
							),
							'element7'
						),
					'element8'
				)
			);
			*/
			

			$test = tw_enumerate_childs($test, 'child');
			var_dump($test->getAllChilds());
			die;

			var_dump($test->nodes[1]->nodes[0]);
			var_dump($test->nodes[1]->nodes[0]->nodes[0]);
			//var_dump(tw_enumerate_childs($test, 'child'));
			die;

			$product = wc_get_product(541);
			$quantity = $product->get_stock_quantity();
			var_dump($product->get_stock_status());
			var_dump($quantity);
			die;


			$datetime1 = DateTime::createFromFormat('Y-m-d H:i:s', '2025-05-24 02:35:00');
			$datetime2 = DateTime::createFromFormat('Y-m-d H:i:s', '2025-05-25 02:35:00');
			
			/*
			var_dump($datetime1);
			var_dump($datetime2);
			var_dump($datetime1->diff($datetime2));
			die;
			*/

			$datetime1 = DateTime::createFromFormat('Y-m-d H:i:s', '2025-05-24 11:35:00');
			$datetime2 = DateTime::createFromFormat('Y-m-d H:i:s', '2025-05-22 10:35:00');

			var_dump(tw_dateinterval_difference_in_seconds($datetime2, $datetime1));
			var_dump($datetime1->diff($datetime2));
			die;

			//pour ce test on en as besoin
			define('WP_ADMIN', true);
			$expeditionId = 30;
			$shippingRepository = TW_Factory::getInstance()->getClass(TW_Shipping_Repository::class);

			$shipping = $shippingRepository->getShippingByShippingId($expeditionId);
			$shippingDetails = $shippingRepository->getShippingDetailsByShippingId($expeditionId);
			$shippingHander = TW_Shipping_Manager::getInstance()->getHandler($shipping, $shippingDetails);
		
			$shippingHander->generatePdf($shipping, $shippingDetails, 'I');
			die;
			//$shippingHander->generateSentArticlesList($shipping, $shippingDetails);
			/**
			 * appeller la shipping factory et voir comment on peut générer le pdf pour vérifier si le hook fonctionne bien
			 */

			/**
			 * method_id flat_rate
			 * instance_id 1
			 */
			$order = wc_get_order(1342);
			$shippingMethods = $order->get_shipping_methods();

			$item = new WC_Order_Item_Shipping(578);
			$item->set_method_id("flat_rate");
			$item->set_instance_id(1);
			$item->save();

			$matches = [];
			preg_match('/<[a-zA-Z@.]*>/', 'John Doe <john.doe@example.com>', $matches);
			var_dump($matches);

			$matches = [];
			var_dump(preg_match('/<[a-zA-Z@.]*>/', 'john.doe@example.com', $matches));
			var_dump($matches);

			$matches = [];
			preg_match('/<[a-zA-Z@.]*>/', 'Techniwayéé <contact@techniway.fr>', $matches);
			var_dump($matches);
			die;

			echo 'cmoi';
            $product = wc_get_product(541);
			var_dump($product->get_stock_quantity());
			var_dump($product->get_manage_stock());

			$product->set_stock_quantity(32);
			$product->save();
			$toto = "lolo";
        }
    );
}, PHP_INT_MAX);

add_filter('automatic_updater_disabled', function($disabled){
	return true;
});

add_filter('product_type_selector', function($product_types){
	$supported_products = [
		'external'	=> __( 'External/Affiliate product', 'woocommerce' )
	];

	foreach($GLOBALS['supported_products_type'] as $product_key => $product_detail) {
		$supported_products[$product_key] = __($product_detail['name'], 'woocommerce');
	}

	return $supported_products;
}, PHP_INT_MAX);

add_action('elementor/dynamic_tags/register', function($dynamic_tag_manager){
	require_once( __DIR__ . '/custom_elementor_tags.php');
	tw_register_custom_elementor_tags_group($dynamic_tag_manager);
	tw_register_custom_elementor_tags($dynamic_tag_manager);
});

add_filter('woocommerce_create_account_default_checked', function($shoudAutomaticallyCreateAccount){
	return true;
}, PHP_INT_MAX);

add_filter('woocommerce_checkout_redirect_empty_cart', function($shouldRedirect){
	return false;
}, PHP_INT_MAX);

add_filter('woocommerce_checkout_update_order_review_expired', function($shouldDisplayErrorMessage){
	if(WC()->cart->is_empty()) {
		$shouldDisplayErrorMessage = false;
	}
	return $shouldDisplayErrorMessage;
}, PHP_INT_MAX);

/*
add_filter('woocommerce_get_script_data', function($params, $handle){
	if($handle == 'wc-checkout') {
		$params['is_checkout'] = 0;
	}

	return $params;
}, PHP_INT_MAX, 2);
*/

add_filter('woocommerce_add_error', function($message){
	if(WC()->cart->is_empty() && is_checkout()){
		$message = __("Vous ne pouvez pas passer commander avec un panier vide !!!", "tw-core");
	}
	return $message;
});

add_filter('woocommerce_product_class', function($classname, $product_type, $product_variation_or_product, $product_id){
	$overriden_classnames = [];
	foreach($GLOBALS['supported_products_type'] as $product_key => $product_detail) {
		$overriden_classnames[$product_key] = $product_detail['initial_classname'];
	}

	if(in_array($classname, array_values($overriden_classnames))){
		$key = array_search($classname, $overriden_classnames);
		$overriden_class_info = $GLOBALS['supported_products_type'][$key];
		
		require_once $overriden_class_info['path'];
		return $overriden_class_info['classname'];
	}

	return $classname;
}, PHP_INT_MAX, 4);

add_filter('woocommerce_data_stores', function($stores){
	require_once __DIR__ . '/classes/tw_product_data_store.php';
	$stores['product'] = TW_Product_Data_Store::class;

	return $stores;
}, PHP_INT_MAX, 1);

/*
add_filter('woocommerce_order_class', function($classname, $order_type, $order_id){
	$overriden_classnames = [];
	foreach($GLOBALS['supported_products_type'] as $product_key => $product_detail) {
		$overriden_classnames[$product_key] = $product_detail['initial_classname'];
	}

	if(in_array($classname, array_values($overriden_classnames))){
		$key = array_search($classname, $overriden_classnames);
		$overriden_class_info = $GLOBALS['supported_products_type'][$key];
		
		require_once $overriden_class_info['path'];
		return $overriden_class_info['classname'];
	}

	return $classname;
}, PHP_INT_MAX, 4);
*/



/*
add_action('woocommerce_checkout_before_order_review', function(){
	$cart = WC()->cart;
	$toto = "lolo";
}, PHP_INT_MAX);
*/

//support de l'ajout au panier des class overloadées
add_action( 'woocommerce_simple-with-variations_add_to_cart', 'woocommerce_simple_add_to_cart', 30);

function tw_core_override_rest_controllers(){
	$rest_handlers_loaded = false;
	$rest_search_handlers = null;

	add_filter('wp_rest_search_handlers', function($handlers) use ($rest_search_handlers, $rest_handlers_loaded){
		$rest_search_handlers = $handlers;
		if($rest_handlers_loaded === false) {
			add_action('rest_api_init', function() use ($rest_search_handlers){
				$tw_rest_search_controller = new TW_Rest_Search_Controller($rest_search_handlers);

				register_rest_route(
					'wp/v2',
					'/search',
					array(
						array(
							'methods' => WP_REST_Server::READABLE,
							'callback' => array($tw_rest_search_controller, 'get_items_with_filter'),
							'permission_callback' => array($tw_rest_search_controller, 'get_items_permission_check'),
							'args' => $tw_rest_search_controller->get_collection_params(),
						),
						'schema' => array($tw_rest_search_controller, 'get_public_item_schema')
					),
					true
				);
			}, PHP_INT_MAX);
		}

		$rest_handlers_loaded = true;
		return $rest_search_handlers;
	});
}
add_action('init', 'tw_core_override_rest_controllers', 0);

function tw_plugin_enqueue_admin_styles() {
    $plugin_url = get_bloginfo('url') . '/wp-content/plugins/tw-core';
	wp_enqueue_editor();
	
	$isElementor = (isset($_GET['action']) && $_GET['action'] == 'elementor') ? true : false;
	if(!$isElementor) {
		wp_enqueue_media();
	}

	tw_enqueue_script('tw_utils', $plugin_url . '/js/tw_utils.js');
	tw_enqueue_style('tw_field', $plugin_url. '/css/metabox_fields.css');
    tw_enqueue_script('tw_field', $plugin_url . '/js/metabox_fields.js', array('jquery', 'jquery-ui-datepicker'));
    tw_enqueue_style( 'tw_field', $plugin_url . '/css/jquery_ui/jquery_ui.css', array());
	tw_enqueue_style('tw_admin_style', $plugin_url . '/css/admin.css');

	tw_enqueue_style('hystmodal', $plugin_url . '/css/hystmodal.min.css');
	tw_enqueue_script('hystmodal', $plugin_url . '/js/hystmodal.min.js');
}
add_action('admin_init', 'tw_plugin_enqueue_admin_styles', 10, 0);

function tw_remove_wc_product_brand(){
	if(tw_is_plugin_active('woocommerce/woocommerce.php')){
		remove_action('woocommerce_register_taxonomy', array(WC_Brands::class, 'init_taxonomy'));
	}
}
add_action('plugins_loaded', 'tw_remove_wc_product_brand', PHP_INT_MAX);

add_filter('pre_option_wc_feature_woocommerce_brands_enabled', function($value, $option, $default_value){
	return 'no';
}, PHP_INT_MAX, 3);