<?php
defined( 'ABSPATH' ) || exit;
?>

<script type="text/javascript">
    document.addEventListener('DOMContentLoaded', function(){
        let shipmentModal = null;

        document.querySelector('.tw-shipment-metabox .add_new_shipment').addEventListener('click', function(){
            shipmentModal = new HystModal({
                catchFocus: true,
                waitTransitions: true,
                closeOnEsc: false,
                closeOnOverlay: false,
                backscroll: false
            });
            shipmentModal.open('#tw-shipment-modal');
        });

        document.querySelector('#tw-shipment-modal [data-hystclose]').addEventListener('click', function(e){
            e.preventDefault();
            e.stopPropagation();
            shipmentModal.close();

            return false;
        });

        document.querySelector('#tw-shipment-modal .save_shipment_button').addEventListener('click', function(e){
            e.preventDefault();
            e.stopPropagation();

            let form = document.querySelector('#tw-shipment-modal form');
            let formData = new FormData(form);

            fetch(
                form.getAttribute('action'),
                {
                    method: 'POST',
                    body: formData
                }
            ).then(function(res){
                let errorContainer = document.querySelector('#tw-shipment-modal .errors');
                errorContainer.innerHTML = "";

                res.json().then(function(jsonResponse){
                    if(jsonResponse['status'] == 'success'){
                        shipmentModal.close();
                        window.location.reload();
                    } else {
                        let errorMsg = [];
                        Object.keys(jsonResponse['errors']).forEach(function(errorIndex){
                            errorMsg.push(jsonResponse['errors'][errorIndex]);
                        });
                        errorContainer.innerHTML = '<p>' + errorMsg.join('<br />') + '</p>';
                    }
                });
            });

            return false;
        });
    });
</script>
<div class="hystmodal" id="tw-shipment-modal" aria-hidden="true">
    <div class="hystmodal__wrap">
        <div style="min-width:70%;padding:20px;" class="hystmodal__window" role="dialog" aria-modal="true">
            <div class="modal-title" style="display:flex;justify-content:space-between;">
                <h2><?php echo __("Ajouter une expédition", "tw-core"); ?></h2>
                <a data-hystclose>X</a>
            </div>
            <div class="modal-content">
                <div style="color:red;" class="errors"></div>
                <form action="/wp-admin/admin-ajax.php?action=tw_add_shipment" method="POST">
                    <?php echo $args['nonce']; ?>
                    <input type="hidden" name="order_id" value="<?php echo $args['order_id']; ?>" />
                    <input type="hidden" name="" value="" />

                    <div class="form-row" style="display: flex; justify-content:space-evenly;">
                        <div style="flex-basis: 50%; margin-right:10px;">
                            <label><?php echo __("Transporteur", "tw-core"); ?></label>
                            <select style="min-width:100%;" name="carrier">
                                <?php foreach($args['shipping_options'] as $carrier_id => $carrier_name) { ?>
                                    <?php if($args['carrier'] !== null && ($args['carrier'] . ':' . $args['carrierInstanceId'] == $carrier_id)) { ?>
                                        <option selected="selected" value="<?php echo $carrier_id ?>"><?php echo $carrier_name; ?></option>
                                    <?php } else { ?>
                                        <option value="<?php echo $carrier_id ?>"><?php echo $carrier_name; ?></option>
                                    <?php } ?>
                                <?php } ?>
                            </select>
                        </div>
                        <div style="flex-basis: 50%;">
                            <label><?php echo __("Type", "tw-core"); ?></label>
                            <select style="min-width:100%;" name="expedition_type">
                                <?php foreach($args['expedition_types'] as $type => $label) { ?>
                                    <option value="<?php echo $type ?>"><?php echo $label; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <table class="wp-list-table widefat fixed striped">
                        <thead>
                            <tr>
                                <th>Articles</th>
                                <th>Quantité expédié</th>
                                <th>Quantité disponible</th>
                                <th>Quantité</th>
                                <th>Prix unitaire</th>
                                <th>Poid unitaire</th>
                                <!--
                                <th>Largeur</th>
                                <th>Longeur</th>
                                <th>Hauteur</th>
                                -->
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($args['ordered_articles'] as $article) { ?>
                            <tr>
                                <td>
                                    <?php echo $article->get_name(); ?>
                                    <input type="hidden" name="articles[<?php echo $article->get_id(); ?>][item_id]" value="<?php echo $article->get_id() ?>" />
                                </td>
                                <td>
                                    <?php 
                                        $shippedQuantity = $article->get_shipped_quantity() !== null ? $article->get_shipped_quantity() : 0;
                                        echo $shippedQuantity;
                                    ?>
                                </td>
                                <td>
                                    <?php 
                                        $availableQuantity = $article->get_stock_available();
                                        echo $availableQuantity;
                                    ?>
                                </td>
                                <td>
                                    <input type="number" name="articles[<?php echo $article->get_id(); ?>][item_quantity]" value="<?php echo $article->get_quantity_to_ship(); ?>" />
                                </td>
                                <td>
                                    <input type="text" name="articles[<?php echo $article->get_id(); ?>][item_price]" value="<?php echo $article->get_product()->get_price(); ?>" />
                                </td>
                                <td>
                                    <input type="text" name="articles[<?php echo $article->get_id(); ?>][item_weight]" value="<?php echo $article->get_product()->get_weight(); ?>" />
                                </td>
                                <!--
                                <td>
                                    <input type="text" name="articles[<?php echo $article->get_id(); ?>][width]" value="<?php echo $article->get_product()->get_width(); ?>" />
                                </td>
                                <td>
                                    <input type="text" name="articles[<?php echo $article->get_id(); ?>][length]" value="<?php echo $article->get_product()->get_length(); ?>" />
                                </td>
                                <td>
                                    <input type="text" name="articles[<?php echo $article->get_id(); ?>][height]" value="<?php echo $article->get_product()->get_height(); ?>" />
                                </td>
                                -->
                            </tr>
                                
                            <?php
                                /*
                                if($article->get_quantity_to_ship() > 0) { ?>
                                    <tr>
                                        <td>
                                            <?php echo $article->get_name(); ?>
                                            <input type="hidden" name="articles[<?php echo $article->get_id(); ?>][id]" value="<?php echo $article->get_id() ?>" />
                                        </td>
                                        <td>
                                            <?php 
                                                $availableQuantity = $article->get_product()->get_stock_quantity() !== null ? $article->get_product()->get_stock_quantity() : 0;
                                                echo $availableQuantity;
                                            ?>
                                        </td>
                                        <td>
                                            <input type="number" name="articles[<?php echo $article->get_id(); ?>][quantity]" value="<?php echo $article->get_quantity_to_ship(); ?>" />
                                        </td>
                                        <td>
                                            <input type="text" name="articles[<?php echo $article->get_id(); ?>][unit_price]" value="<?php echo $article->get_product()->get_price(); ?>" />
                                        </td>
                                        <td>
                                            <input type="text" name="articles[<?php echo $article->get_id(); ?>][weight]" value="<?php echo $article->get_product()->get_weight(); ?>" />
                                        </td>
                                        <!--
                                        <td>
                                            <input type="text" name="articles[<?php echo $article->get_id(); ?>][width]" value="<?php echo $article->get_product()->get_width(); ?>" />
                                        </td>
                                        <td>
                                            <input type="text" name="articles[<?php echo $article->get_id(); ?>][length]" value="<?php echo $article->get_product()->get_length(); ?>" />
                                        </td>
                                        <td>
                                            <input type="text" name="articles[<?php echo $article->get_id(); ?>][height]" value="<?php echo $article->get_product()->get_height(); ?>" />
                                        </td>
                                        -->
                                    </tr>
                                <?php } else { ?>
                                    <tr class="allready_shipped">
                                        <td><?php echo $article->get_name(); ?></td>
                                        <td>
                                            <?php 
                                                $availableQuantity = $article->get_product()->get_stock_quantity() !== null ? $article->get_product()->get_stock_quantity() : 0;
                                                echo $availableQuantity;
                                            ?>
                                        </td>
                                        <td>
                                            <?php echo $article->get_quantity_to_ship(); ?>
                                        </td>
                                        <td>
                                            <?php echo $article->get_product()->get_price(); ?>
                                        </td>
                                        <td>
                                            <?php echo $article->get_product()->get_weight(); ?>
                                        </td>
                                        <!--
                                        <td>
                                            <?php echo $article->get_product()->get_width(); ?>
                                        </td>
                                        <td>
                                            <?php echo $article->get_product()->get_length(); ?>
                                        </td>
                                        <td>
                                            <?php echo $article->get_product()->get_height(); ?>
                                        </td>
                                        -->
                                    </tr>
                                <?php } 
                                */
                                ?>
                            <?php } ?>
                        </tbody>
                    </table>

                    <div class="form-row" style="width:50%;">
                        <label><?php echo __("Assurance", "tw-core"); ?></label>
                        <select style="min-width:100%;" name="ship_with_insurance">
                            <option value="no"><?php echo __("Non", "tw-core") ?></option>
                            <option value="yes"><?php echo __("Oui", "tw-core") ?></option>
                        </select>
                    </div>

                    <button style="margin-top:10px;" class="save_shipment_button button button-primary" type="submit">Enregistrer</button>
                </form>
            </div>
        </div>
    </div>
</div>