<?php

class TW_Task_Process_Product_Sold_Previous_Year {
    public function execute($taskInfo, $args = []){
        $success = true;
        $response = [];
        $now = new DateTime();

        $productRepository = TW_Factory::getInstance()->getClass(TW_Product_Repository::class);
        
        $year = (int)$now->format('Y') - 1;
        $statData = $productRepository->getWeeklyBoughtQuantity($taskInfo['name'], $year);
        if(empty($statData)){
            $success = false;
            $response = ['EMPTY DATA'];
            return [$success, $response];
        }

        $predictorValues = array_keys($statData);
        $predictorValues = array_map(function($item){
            return (int)$item;
        }, $predictorValues);

        $predictedValues = array_values($statData);
        $predictedValues = array_map(function($item){
            return (float)$item;
        }, $predictorValues);

        $jsonForecastData = [
            'year' => $year,
            'name' => 'weekly_sold_quantity_' . $taskInfo['name'],
            'predictor_label' => 'weekNumber',
            'predictor_values' => $predictorValues,
            'predicted_label' => 'soldQuantity',
            'predicted_values' => $predictedValues
        ];
        $forecastFileName = TW_PREDICTOR_IMPORT_FOLDER . DIRECTORY_SEPARATOR . $jsonForecastData['name'] . '__' . (string)$jsonForecastData['year'] . '.json';
        file_put_contents($forecastFileName, json_encode($jsonForecastData));

        try {
            $cliResult = [];
            $cmd = "python3 process_segment_regression --name " . $jsonForecastData['name'] . " --year " . (string)$year . " --overwrite 0";
            $cliLine = "cd " . TW_PREDICTOR_IMPORT_FOLDER . " && " . $cmd . " 2>&1" ;
            $executionResult = exec($cliLine, $cliResult);

            if($executionResult == false) {
                throw new Exception("EXECUTION ERROR");
            }

            $encodedResult = json_decode(implode("", $cliResult));
            if($encodedResult['status'] == 'error') {
                throw new Exception(implode("", $cliResult));
            }

            $success = true;
            $response = $encodedResult['message'];
        } catch(Exception $ex) {
            $success = false;
            $response = "AN EXCEPTION OCCURED WHILE EXECUTING THE COMMAND";
        }
        return [$success, $response];
    }
}