<?php
defined( 'ABSPATH' ) || exit;

class TW_Linked_Page_Repository {

    public function delete($postId)
    {
        global $wpdb;
        $wpdb->query("DELETE FROM tw_linked_page WHERE post_id = '" . esc_sql($postId) . "'");
    }

    public function insert($url, $postId, $pageType, $widgetPostType, $widgetTemplateId){
        global $wpdb;
        $wpdb->insert(
            'tw_linked_page',
            array(
                'post_id' => $postId,
                'page_type' => $pageType,
                'page_url' => $url,
                'widget_post_type' => $widgetPostType, 
                'global_widget_template_id' => $widgetTemplateId
            )
        );
    }

    public function getLinkedPagesWithPostTypes($postType, $postIdToExclude = null)
    {
        $query = "
            SELECT tlp.*
            FROM tw_linked_page tlp
            WHERE tlp.widget_post_type IN (" . tw_explode_strings($postType) . ")";

        if($postIdToExclude !== null) {
            $query .= " AND tlp.post_id != " . esc_sql($postIdToExclude);
        }

        global $wpdb;
        return $wpdb->get_results($query, ARRAY_A);
    }

    public function getLinkedPagesWithWidget($linkedWidgets, $postIdToExclude = null)
    {
        $query = "
            SELECT tlp.*
            FROM tw_linked_page tlp
            WHERE tlp.global_widget_template_id IN (" . tw_explode_strings($linkedWidgets) . ")";

        if($postIdToExclude !== null) {
            $query .= " AND tlp.post_id != " . esc_sql($postIdToExclude);
        }

        global $wpdb;
        return $wpdb->get_results($query, ARRAY_A);
    }
}

