<?php
defined( 'ABSPATH' ) || exit;

class TW_External_Stock_Repository {
    public function getStocks($products)
    {
        $res = [];

        if(count($products) > 0) {
            $productIds = [];
            foreach($products as $product) {
                $productIds[] = $product->get_id();
            }

            global $wpdb;
            $stmt = "SELECT ts.* FROM tw_external_stock ts WHERE ts.product_id IN(" . tw_explode_ids($productIds) . ")";
            
            $fetchedRes = $wpdb->get_results($stmt, ARRAY_A);
            foreach($fetchedRes as $item) {
                $res[$item['product_id']] = $item;
            }

            return $res;
        }
    }

    public function updateStock($stockToRefresh)
    {
        global $wpdb;
        $now = new DateTime();
        $productIds = array_keys($stockToRefresh);

        $res = [];
        if(count($productIds) > 0) {
            $stmt = "SELECT ts.* FROM tw_external_stock ts WHERE ts.product_id IN(" . tw_explode_ids($productIds) . ")";
            $res = $wpdb->get_results($stmt, ARRAY_A);
        }
        
        $productIdsToUpdate = [];
        foreach($res as $item) {
            $productIdsToUpdate[] = $item['product_id'];
        }

        $productIdsToInsert = array_diff($productIds, $productIdsToUpdate);
        foreach($productIdsToInsert as $id) {
            $wpdb->insert(
                'tw_external_stock',
                [
                    'product_id' => $id,
                    'quantity' => $stockToRefresh[$id],
                    'last_checked' => $now->format('Y-m-d H:i:s')
                ]
            );
        }

        foreach($productIdsToUpdate as $id) {
            $wpdb->update(
                'tw_external_stock',
                [
                    'quantity' => $stockToRefresh[$id],
                    'last_checked' => $now->format('Y-m-d H:i:s')
                ],
                [
                    'product_id' => $id
                ]
            );
        }
    }

    public function deleteStock($productId)
    {
        global $wpdb;
        $wpdb->delete(
            'tw_external_stock',
            [
                'product_id' => $productId
            ]
        );
    }
}