<?php
defined( 'ABSPATH' ) || exit;

class TW_Cached_Page_Repository {

    public function insert($timestamp, $pageUrl){
        global $wpdb;
        $existingPages = $this->getExistingUrl($pageUrl);

        $shouldInsert = true;
        if(count($existingPages) > 0) {
            $shouldInsert = false;
        }

        if($shouldInsert) {
            $wpdb->insert(
                'tw_cached_page_manager',
                array(
                    'creation_timestamp' => $timestamp,
                    'url' => $pageUrl,
                    'cached' => 0
                )
            );
        } else {
            $wpdb->update(
                'tw_cached_page_manager',
                 array(
                    'creation_timestamp' => $timestamp,
                    'url' => $pageUrl,
                    'cached' => 0
                ),
                array(
                    'url' => $pageUrl
                ),
            );
        }
    }

    public function markAsLoaded($currentTimestamp, $pageUrl){
        global $wpdb;
        $wpdb->update(
            'tw_cached_page_manager',
            array(
                'creation_timestamp' => $currentTimestamp,
                'url' => $pageUrl,
                'cached' => 1
            ),
            array(
                'url' => $pageUrl,
                'cached' => 0
            )
        );
    }

    public function getExistingUrl($existingUrl)
    {
        
        $urls = [];
        global $wpdb;
        $query = "
            SELECT tcp.*
            FROM tw_cached_page_manager tcp
            WHERE tcp.url = '" . esc_sql($existingUrl) . "'";


        $res = $wpdb->get_results($query, ARRAY_A);
        foreach($res as $item) {
            $urls[] = $item['url'];
        }
        return $urls;
    }

    public function getUrlToCache()
    {
        $urls = [];
        global $wpdb;
        $query = "
            SELECT tcp.*
            FROM tw_cached_page_manager tcp
            WHERE tcp.cached = 0";


        $res = $wpdb->get_results($query, ARRAY_A);
        foreach($res as $item) {
            $urls[] = $item['url'];
        }
        return $urls;
    }
}

