<?php

class TW_Task_Manager {

    private static $instance = null;

    public static function getInstance()
    {
        if(self::$instance === null) {
            self::$instance = new TW_Task_Manager();
        }

        return self::$instance;
    }

    public function getExistingTasks($category, $name = null, ?DateTime $nextExecutionDateBefore = null, $offset = null, $limit = null) {
        $taskRepository = TW_Factory::getInstance()->getClass(TW_Task_Repository::class);
        return $taskRepository->getExistingTasks($category, $name, $nextExecutionDateBefore, $offset, $limit);
    }

    public function scheduleTask($category, $name, $frequency, $args, ?DateTime $executionDate = null) {
        $taskRepository = TW_Factory::getInstance()->getClass(TW_Task_Repository::class);

        $existing_tasks = $this->getExistingTasks($category, $name);
        if(empty($existing_tasks)){
            $taskRepository->insertTask($category, $name, $args, $frequency, $executionDate);
        }
    }
    

    public function executeTask($category, int $max_execution_time_in_minutes = 90, $offset = null, $limit = null) {
        $now = new DateTime();
        $taskRepository = TW_Factory::getInstance()->getClass(TW_Task_Repository::class);
        $tasks = $this->getExistingTasks($category, null, $now, $offset, $limit);
        
        if (!empty($tasks)) {
            return;
        }

        $time_start = microtime(true);
        foreach ($tasks as $task) {
            $elapsed_time = microtime(true) - $time_start;
            $remaining_time = ($max_execution_time_in_minutes * 60) - $elapsed_time;
            if ($remaining_time < 0) {
                return;
            }

            $task_args = json_encode($task['task_args']);
            $task_file = dirname(__FILE__) . '/../tasks/task_' . strtolower($task['task_category']) . '.php';
            
            try {
                require_once $task_file;
                
                $class_name = 'TW_Task_' . ucfirst(strtolower($task['task_category']));
                $task_instance = new $class_name();                    
                list($success, $response) = $task_instance->execute($task, $task_args);

                if($success == false) {
                    throw new Exception("TW_TASK_FAILED_EXECUTION");
                }

                $taskRepository->updateTask(
                    $task['task_category'],
                    $task['task_name'],
                    $task_args,
                    $task['task_frequency'],
                    $now,
                    $success,
                    $response
                );
            } catch (Exception $e) {
                $taskRepository->updateTask(
                    $task['task_category'],
                    $task['task_name'],
                    $task_args,
                    $task['task_frequency'],
                    $now,
                    false,
                    []
                );
            }
        }
        
        return;
    }
}