<?php

class TW_Supercache_Linked_Content_Manager {

    const MAX_NUMBER_PAGES_TO_CACHE = 8;

    /**
     *  TODO vérifier que les urls ne sont pas marqués en double
     */
    private function _tw_elementor_get_urls_to_refresh(\Elementor\Core\Base\Document $currentDocument, $conditionName, $conditionSubName)
    {
        $currentDocumentName = $currentDocument->get_name();
        $postId = $currentDocument->get_post()->ID;

        $urlToRefresh = [];
        if($currentDocumentName == 'product') {
            $products = get_posts([
                'numberposts' => -1,
                'post_type' => 'product',
                'posts_per_page' => -1,
                'post_status' => 'publish',
            ]);
            foreach($products as $post) {
                $urlToRefresh[] = get_permalink($post->ID);
            }
        } else if($currentDocumentName == 'product-archive') {
            $urlToRefresh[] = get_post_type_archive_link('product');
            $productCategories = TW_Factory::getInstance()->getClass(TW_Product_Repository::class)->getProductCategories();
            foreach($productCategories as $cat) {
                $urlToRefresh[] = get_term_link((int)$cat['term_id'], 'product_cat');
            }
        } else if($currentDocumentName == 'archive') {
            $urlToRefresh[] = get_post_type_archive_link($conditionName);
        } else if($currentDocumentName == 'single-page') {
            if(!empty($conditionName) && empty($conditionSubName)) {
                $pages = get_posts([
                    'numberposts' => -1,
                    'post_type' => $conditionName,
                    'posts_per_page' => -1,
                    'post_status' => 'publish',
                ]);
                foreach($pages as $page) {
                    $urlToRefresh[] = get_permalink($page->ID);
                }
            } else if(!empty($conditionName) && !empty($conditionSubName)) {
                $pages = get_posts([
                    'numberposts' => -1,
                    'post_type' => $conditionName,
                    'posts_per_page' => -1,
                    'post_status' => 'publish',
                    'post_name' => $conditionSubName
                ]);
                foreach($pages as $page) {
                    $urlToRefresh[] = get_permalink($page->ID);
                }
            }
        } else if($currentDocumentName == 'wp-page') {
            $urlToRefresh[] = get_permalink($postId);
        }
        return $urlToRefresh;
    }

    private function _saveLinkedPages($relatedPostTypes, $relatedGlobalWidgets, $pageUrl, $post_id, $pageType)
    {
        TW_Factory::getInstance()->getClass(TW_Linked_Page_Repository::class)->delete($post_id);
        TW_Factory::getInstance()->getClass(TW_Linked_Page_Repository::class)->insert(
            $pageUrl,
            $post_id,
            $pageType,
            null,
            null
        );
        foreach($relatedPostTypes as $type) {
            TW_Factory::getInstance()->getClass(TW_Linked_Page_Repository::class)->insert(
                $pageUrl,
                $post_id,
                $pageType,
                $type,
                null
            );
        }
        foreach($relatedGlobalWidgets as $widget) {
            TW_Factory::getInstance()->getClass(TW_Linked_Page_Repository::class)->insert(
                $pageUrl,
                $post_id,
                $pageType,
                null,
                $widget
            );
        }
    }

    private function _savePagesToPreload($urlToRefresh)
    {
        $currentTimestamp = strtotime('now');
        foreach($urlToRefresh as $url) {
            $urlToRefresh = TW_Factory::getInstance()->getClass(TW_Cached_Page_Repository::class)->insert($currentTimestamp, $url);
        }
    }

    public function tw_elementor_document_info(\Elementor\Core\Base\Document $currentDocument, $post_id, $appendToPostTypeFn = null)
    {
        $pageUrl = null;
        $pageType = null;
        $conditionName = null;
        $conditionSubName = null;
        $currentDocumentName = null;

        $currentDocumentName = $currentDocument->get_name();
        $pageType = $currentDocumentName;

        if(in_array($currentDocumentName, ['product-archive', 'product'])){
            if($appendToPostTypeFn !== null) {
                $appendToPostTypeFn('product');
            }

            if($currentDocumentName == 'product-archive') {
                $pageUrl = get_post_type_archive_link('product');
            }
        } else if(in_array($currentDocumentName, ['archive'])){
            $conditions_manager = \ElementorPro\Plugin::instance()->modules_manager->get_modules('theme-builder')->get_conditions_manager();
            $conditions = $conditions_manager->get_document_conditions($currentDocument);

            if(!empty($conditions) && !empty($conditions[0]['sub_name']) && preg_match('/_archive/', $conditions[0]['sub_name'])){
                $conditionName = $conditions[0]['name'];
                $conditionSubName = $conditions[0]['sub_name'];

                $conditionName = str_replace('_archive', '', $conditions[0]['sub_name']);
                if($appendToPostTypeFn !== null) {
                    $appendToPostTypeFn($conditionName);
                }
                $pageUrl = get_post_type_archive_link($conditions[0]['sub_name']);
            }
        } else if(in_array($currentDocumentName, ['single-page'])){
            $conditions_manager = \ElementorPro\Plugin::instance()->modules_manager->get_modules('theme-builder')->get_conditions_manager();
            $conditions = $conditions_manager->get_document_conditions($currentDocument);

            if(!empty($conditions) && isset($conditions[0])){
                if(!empty($conditions[0]['sub_name']) && !empty($conditions[0]['sub_id'])){
                    $conditionName = $conditions[0]['sub_name'];
                    $conditionSubName = $conditions[0]['sub_id'];

                    if(filter_var($conditionSubName, FILTER_VALIDATE_INT) !== false) {
                        $selectedPost = get_post($conditionSubName);
                        if($selectedPost !== null) {
                            $conditionSubName = $selectedPost->post_name;
                        }
                    }

                    
                    if($appendToPostTypeFn !== null) {
                        $appendToPostTypeFn($conditions[0]['sub_name']);
                    }   
                    $pageUrl = get_permalink($post_id);
                } else if(!empty($conditions[0]['sub_name'])){
                    $conditionName = $conditions[0]['sub_name'];

                    if($appendToPostTypeFn !== null) {
                        $appendToPostTypeFn($conditions[0]['sub_name']);
                    }
                    $pageUrl = get_post_type_archive_link($conditions[0]['sub_name']);
                } else {
                    $pageType = "multiple-pages";
                }
            }
        } else if(in_array($currentDocumentName, ['wp-page'])){
            $pageUrl = get_permalink($post_id);
            $pageType = "single-page";
        }

        return [$pageUrl, $pageType, $conditionName, $conditionSubName, $currentDocumentName];
    }

    public function tw_purge_cache_linked_page($post_id, $editor_data)
    {
        $relatedPostTypes = [];
        $relatedGlobalWidgets = [];

        $appendToPostTypeFn = function($postType) use (&$relatedPostTypes) {
            if(!in_array($postType, $relatedPostTypes)){
                $relatedPostTypes[] = $postType;
            }
        };

        $linkedUrlsFromDocumentFn = function($postId, $cacheLinkedContentManager){
            $documentUrls = [];
            $linkedDocument = \Elementor\Plugin::instance()->documents->get($postId);

            if($linkedDocument !== false) {
                list($pageUrl, $pageType, $conditionName, $conditionSubName, $currentDocumentName) = $cacheLinkedContentManager->tw_elementor_document_info(
                    $linkedDocument,
                    $postId
                );
                $linkedUrls = $cacheLinkedContentManager->_tw_elementor_get_urls_to_refresh($linkedDocument, $conditionName, $conditionSubName);
                foreach($linkedUrls as $item) {
                    $documentUrls[] = $item;
                }
            }
            return $documentUrls;
        };

        //enumerate all elementor saved elements in this document
        $elements = tw_enumerate_childs($editor_data, 'elements', function($item){
            return isset($item['elType']);
        })->getAllChilds();

        foreach($elements as $elem) {
            if($elem['elType'] == 'widget'){
                if(strtolower($elem['widgetType']) == 'loop-carousel' || strtolower($elem['widgetType']) == 'loop-grid') {
                    $parsedElement = \Elementor\Plugin::instance()->elements_manager->create_element_instance($elem);
                    
                    $widgetSkinType = $parsedElement->get_settings('_skin');
                    $widgetPostType = $widgetSkinType !== null ? $parsedElement->get_settings($widgetSkinType . '_query_post_type') : null;
                     
                    if(in_array($widgetPostType, get_post_types())){
                        $appendToPostTypeFn($widgetPostType);
                    }
                } else if(strtolower($elem['widgetType']) == 'slides') {
                    $parsedElement = \Elementor\Plugin::instance()->elements_manager->create_element_instance($elem);
                    foreach($parsedElement->get_settings()['slides'] as $slideInfo) {
                        if(isset($slideInfo['__dynamic__'])){
                            foreach($slideInfo['__dynamic__'] as $dynamicElement => $dynamicValue) {
                                $dynamicDetail = \Elementor\Plugin::instance()->dynamic_tags->tag_text_to_tag_data($dynamicValue);
                                $group = \Elementor\Plugin::instance()->dynamic_tags->get_tags()[$dynamicDetail['name']]['instance']->get_group();
                                if($group == 'woocommerce') {
                                    $group = 'product';
                                }

                                if(in_array($group, get_post_types())){
                                    $appendToPostTypeFn($group);
                                }

                            }
                        }
                    }
                } else if(strtolower($elem['widgetType']) == 'global') {
                    if(!in_array($elem['templateID'], $relatedGlobalWidgets)){
                        $relatedGlobalWidgets[] = $elem['templateID'];
                    }
                }
            }
        }

        $currentDocument = \Elementor\Plugin::instance()->documents->get_current();
        list($pageUrl, $pageType, $conditionName, $conditionSubName, $currentDocumentName) = $this->tw_elementor_document_info(
            $currentDocument,
            $post_id,
            function($postTypeToAppend) use (&$relatedPostTypes) {
                if(!in_array($postTypeToAppend, $relatedPostTypes)){
                    $relatedPostTypes[] = $postTypeToAppend;
                }
            }
        );
        
        $this->_saveLinkedPages(
            $relatedPostTypes,
            $relatedGlobalWidgets,
            $pageUrl,
            $post_id,
            $pageType
        );

        $urlToRefresh = $this->_tw_elementor_get_urls_to_refresh(
            $currentDocument,
            $conditionName,
            $conditionSubName,
            $relatedPostTypes,
            $relatedGlobalWidgets
        );

        if(count($relatedPostTypes) > 0){
            $linkedPagesWithPostTypes = TW_Factory::getInstance()->getClass(TW_Linked_Page_Repository::class)->getLinkedPagesWithPostTypes($relatedPostTypes, $post_id);
            foreach($linkedPagesWithPostTypes as $linkedPage) {
                $linkedPage['page_url'] = $linkedUrlsFromDocumentFn($linkedPage['post_id'], $this);
                foreach($linkedPage['page_url'] as $url) {
                    $urlToRefresh[] = $url;
                }
            }
        }

        if(count($relatedGlobalWidgets) > 0){
            $linkedPagesWithWidget = TW_Factory::getInstance()->getClass(TW_Linked_Page_Repository::class)->getLinkedPagesWithWidget($relatedGlobalWidgets, $post_id);
            foreach($linkedPagesWithWidget as &$linkedPage) {
                $linkedPage['page_url'] = $linkedUrlsFromDocumentFn($linkedPage['post_id'], $this);
                foreach($linkedPage['page_url'] as $url) {
                    $urlToRefresh[] = $url;
                }
            }
        }

        $urlToRefresh = array_unique($urlToRefresh);
        foreach($urlToRefresh as $url) {
            $url_info = wp_parse_url($url);
            $cacheDir = get_supercache_dir() . $url_info['path'];
            wpsc_delete_files($cacheDir, false);
        }

        $this->_savePagesToPreload($urlToRefresh);
        //$this->tw_preload_cache($urlToRefresh);
    }

    public function tw_preload_cache($urlToRefresh = [])
    {
        global $tw_logger;

        if(empty($urlToRefresh)){
            $urlToRefresh = TW_Factory::getInstance()->getClass(TW_Cached_Page_Repository::class)->getUrlToCache();
        } 

        $selectedUrlsToRefresh = [];
        $sortedUrlsToRefresh = [];
        $urlBase = rtrim(get_site_url(), '/');
        foreach($urlToRefresh as $item) {
            $baseIndex = strpos($item, $urlBase);
            $urlWithoutBase = substr($item, strlen($urlBase));
            $urlWithoutBase = ltrim($urlWithoutBase, '/');

            $exploded = explode('/', $urlWithoutBase);
            if(count($exploded) > 0) {
                $firstSegment = $exploded[0];
                $secondSegment = count($exploded) > 1 ? $exploded[1] : '';

                //$urlKey = $firstSegment . '___' . $secondSegment;
                if(!isset($sortedUrlsToRefresh[$firstSegment])){
                    $sortedUrlsToRefresh[$firstSegment] = [];
                }
                $sortedUrlsToRefresh[$firstSegment][] = $item;
            }
        }

        usort($sortedUrlsToRefresh, function($item1, $item2){
            return count($item1) > count($item2) ? -1 : 1;
        });

        $segmentKeys = array_keys($sortedUrlsToRefresh);
        for($i=0;$i<self::MAX_NUMBER_PAGES_TO_CACHE;$i++) {
            $loopIndex = (int)($i / count($segmentKeys));
            $currentIndex = $i - ($loopIndex * count($segmentKeys));

            if(count($sortedUrlsToRefresh[$segmentKeys[$currentIndex]]) > 0){
                $selectedUrlsToRefresh[] = array_shift($sortedUrlsToRefresh[$segmentKeys[$currentIndex]]);
            }
        }

        $now = new DateTime();
        $timestamp = $now->format('U');
        $hash = wp_hash('tw_preload_cache_' . $timestamp, 'nonce');

        $url = rtrim(get_site_url(), '/') . '/wp-json/tw-cache/v1/preload';
        $url .= '?timestamp=' . $timestamp;
        $url .= '&hash=' . $hash;

        
        $tw_logger->debug("calling " . $url);
        $tw_logger->debug(json_encode(['url' => $selectedUrlsToRefresh]));

        $ch = curl_init($url);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['url' => $selectedUrlsToRefresh]));

        curl_setopt($ch, CURLOPT_TIMEOUT_MS, 5000); // 100 ms timeout
        //curl_setopt($ch, CURLOPT_NOSIGNAL, 1);    // Needed for timeouts < 1s on some systems
        $res = curl_exec($ch);
        $tw_logger->debug(print_r($res, true));
        curl_close($ch);
    }
}