<?php

defined( 'ABSPATH' ) || exit;

class TW_Shipping_Manager {

    private static $instance = null;
    private $registeredHandlers = [];

    protected function __construct()
    {
    }

    public static function getInstance()
    {
        if(self::$instance === null) {
            self::$instance = new TW_Shipping_Manager();
        }

        return self::$instance;
    }

    /**
     * récupérer le carrier
     * les order_items
     * 
     * pour chaque order_items on va prendre la quantité en stock
     * on va transformer cela en shipmentDetail (méthode ci dessous) 
     */
    public function createShipmentInfoFromEmptyShipment($orderId)
    {
        require_once __DIR__ . '/tw_order_item_product.php';
        $shipment = null;
        $shipmentDetails = [];
        $shippingRepository = TW_Factory::getInstance()->getClass(TW_Shipping_Repository::class);

        $existingShippings = $shippingRepository->getShippingsByOrderId($orderId, true);

        if(count($existingShippings) == 0){
            $order = wc_get_order($orderId);
            $ordered_shipping = null;
            if(!empty($order->get_items('shipping'))){
                $ordered_shippings = $order->get_items('shipping');
                $ordered_shipping = $ordered_shippings[array_keys($ordered_shippings)[0]];
            }

            $carrier = null;
            $carrierInstanceId = null;
            if($ordered_shipping !== null){
                $carrier = $ordered_shipping->get_method_id();
                $carrierInstanceId = $ordered_shipping->get_instance_id();
            }

            $ordered_articles = [];
            foreach($order->get_items('line_item') as $item) {
                $article = new TW_Order_Item_Product($item->get_id());

                $ordered_quantity = (int)$article->get_quantity();
                $allready_shipped_quantity = TW_Factory::getInstance()->getClass(TW_Shipping_Repository::class)->getShippedQuantityForOrderItem(
                    $orderId,
                    $article->get_id()
                );

                $article->set_shipped_quantity($allready_shipped_quantity);
                $quantity_to_ship = $ordered_quantity - $allready_shipped_quantity;
                $article->set_quantity_to_ship($quantity_to_ship);

                $ordered_articles[$article->get_id()] = $article;
            }

            if($carrier !== null && $carrierInstanceId !== null && count($ordered_articles) >  0) {
                $articlesList = [];
                foreach($ordered_articles as $item) {

                    if($item->get_quantity_to_ship() > 0 &&  $item->has_enough_quantity_for_shipment($item->get_quantity_to_ship())){
                        $articlesList[] = [     
                            'item_quantity' => (int)$item->get_quantity_to_ship(),
                            'item_id' => $item->get_id(),
                            'item_price' => $item->convert_to_number($item->get_product()->get_price('edit')),
                            'item_weight' => $item->convert_to_number($item->get_product()->get_weight('edit'))
                        ];
                    }
                }

                if(count($articlesList) > 0){
                    list($shipment, $shipmentDetails) = $this->createShipmentInfo(
                        $orderId,
                        $carrier . ':' . $carrierInstanceId,
                        "outward",
                        $articlesList,
                        false
                    );
                }
            }
        }
        return [$shipment, $shipmentDetails];
    }
    
    public function createShipmentInfo($orderId, $carrier, $expeditionType, $articles, $useInsurance)
    {
        $useInsurance = $useInsurance == 'yes' ? 1 : 0;
        $shippingRepository = TW_Factory::getInstance()->getClass(TW_Shipping_Repository::class);
        
        $shipment = new TW_Shipping([
            'order_id' => $orderId,
            'carrier' => $carrier,
            'expedition_type' => $expeditionType,
            'insurance' => $useInsurance
        ]);
        $shippingId = $shippingRepository->insert_shipping($shipment);
        $shipment->expedition_id = $shippingId;

        $shipmentDetails = [];
        foreach($articles as $item) {
            $quantity = filter_var($item['item_quantity'], FILTER_VALIDATE_INT) !== false ? filter_var($item['item_quantity'], FILTER_VALIDATE_INT) : 1;

            if($quantity > 0) {
                $shipmentDetails[] = new TW_Shipping_Detail([
                    'expedition_id' => $shippingId,
                    'item_id' => (int)$item['item_id'],
                    'item_quantity' => (int)$quantity,
                    'item_price' => isset($item['item_price']) ? (float)$item['item_price'] : null,
                    'item_weight' => isset($item['item_weight']) ? (float)$item['item_weight'] : null,
                ]);
            }
        }
        $shippingRepository->insert_shipping_details($shipmentDetails);
        return [$shipment, $shipmentDetails];
    }

    public function registerHandler(TW_Shipping_Handler $handler)
    {
        $this->registeredHandlers[get_class($handler)] = $handler;
    }

    public function getHandler(TW_Shipping $shipping, $shipmentDetails)
    {
        $handler = null;
        foreach($this->registeredHandlers as $item) {
            if($item->canHandle($shipping)){
                $handler = $item;
                break;
            }
        }
        return $handler;
    }
}