<?php

class TW_External_Stock_Manager {

    private static $instance = null;
    private $registeredHandlers = [];

    public static function getInstance()
    {
        if(self::$instance === null) {
            self::$instance = new TW_External_Stock_Manager();
        }

        return self::$instance;
    }

    public function registerHandler(TW_External_Stock_Handler $handler)
    {
        $this->registeredHandlers[get_class($handler)] = $handler;
    }

    /**
     * $products (liste de WC_Product)
     */
    public function getProductStocks($products, $forceRefresh = true)
    {
        $productStocks = [];
        $refreshedStocks = [];
        $handlerToCalls = [];

        foreach($products as $product) {
            foreach($this->registeredHandlers as $handlerClass => $handler) {
                if($handler->canHandle($product)) {
                    if(!isset($handlerToCalls[$handlerClass])){
                        $handlerToCalls[$handlerClass] = [];
                    }

                    $handlerToCalls[$handlerClass][] = $product;
                    break;
                }
            }
        }

        foreach($handlerToCalls as $handlerClass => $products) {
            list($handlerTotalStocks, $handlerRefreshedStocks) = $this->registeredHandlers[$handlerClass]->getProductStocks($products, $forceRefresh);
            foreach($handlerTotalStocks as $productId => $stock) {
                $productStocks[$productId] = $stock; 
            }

            foreach($handlerRefreshedStocks as $productId => $stock) {
                $refreshedStocks[$productId] = $stock;
            }
        }
        
        TW_Factory::getInstance()->getClass(TW_External_Stock_Repository::class)->updateStock($refreshedStocks);
        return $productStocks;
    }
}