(function($) {
    function get_violations($form,validatedCustomFields){
        var violations = {};

        validatedFieldKeys = Object.keys(validatedCustomFields);
        for(inputKey in validatedFieldKeys) {
            var inputName = validatedFieldKeys[inputKey];
            
            if($form.find(inputName).length > 0) {
                for(var i=0; i<validatedCustomFields[inputName]['rules'].length; i++) {
                    var rule = validatedCustomFields[inputName]['rules'][i];
                    if(rule['type'] == 'required') {
                        if($form.find(inputName).val().trim() == "") {
                            if(typeof(violations[inputName]) == "undefined") {
                                violations[inputName] = [];
                            }
                            violations[inputName].push(rule['message']);
                        }
                    } else if(rule['type'] == 'minLength') {
                        var value = $form.find(inputName).val().trim();
                        if(value.length < rule['minLength']){
                            if(typeof(violations[inputName]) == "undefined") {
                                violations[inputName] = [];
                            }
                            violations[inputName].push(rule['message']);
                        }
                    }
                }
            }
        }
        return violations;
    }

    function displayNotice($form, violations){
        $form.prepend('<div class="tw-notice"><p>Echec de la validation</div>');
    }

    function displayErrors($form, violatedCustomFields) {
        var violatedCustomFieldsKeys = Object.keys(violatedCustomFields);
        for(inputKey in violatedCustomFieldsKeys) {
            var inputName = violatedCustomFieldsKeys[inputKey];

            if(inputName.indexOf(':input[name="tax') != -1) {
                for(var i=0; i<violatedCustomFields[inputName].length; i++) {
                    var errorMessage = violatedCustomFields[inputName][i];
                    $form.find(inputName).closest('.tagsdiv').prepend('<div class="tw-error"><p>' + errorMessage + '</p></div>');
                }
                continue;
            }

            if($form.find(inputName).closest('td').find('.tw-field').length < 1) {
                if ($form.find(inputName).prev().is('label')){
                    var $label = $form.find($form.find(inputName).prev());

                    $form.find(inputName).parent().addClass('tw-field');
                    $form.find(inputName).wrap('<div class="tw-input-wrap"></div>');
                    $form.find(inputName).parent().wrap('<div class="tw-input"></div>');
                    $form.find(inputName).before($label);
                } else if($form.find(inputName).prev().hasClass('tw-gallery')){
                    $form.find(inputName).parent().addClass('tw-field');
                    $form.find(inputName).parent().wrapInner('<div class="tw-input-wrap"></div>');
                    $form.find(inputName).find('.tw-input-wrap').wrap('<div class="tw-input"></div>');
                } else {
                    $form.find(inputName).parent().addClass('tw-field');
                    $form.find(inputName).wrap('<div class="tw-input-wrap"></div>');
                    $form.find(inputName).parent().wrap('<div class="tw-input"></div>');
                }
            }

            for(var i=0; i<violatedCustomFields[inputName].length; i++) {
                var errorMessage = violatedCustomFields[inputName][i];
                $form.find(inputName).closest('.tw-field').prepend('<div class="tw-error"><p>' + errorMessage + '</p></div>');
            }
        }
    }

    $('input[type="submit"]').on('click', function(e){
        $form = $('form[name="post"]');
        validatedCustomFields = JSON.parse(tw_validation_rules);

        $form.find('.tw-notice').remove();
        $form.find('.tw-error').remove();
        
        var violations = get_violations($form, validatedCustomFields);

        if(Object.keys(violations).length > 0) {
            e.stopImmediatePropagation();

            displayNotice($form, violations);
            displayErrors($form, violations);
            return false;
        }       
    });
})(jQuery);