document.addEventListener('DOMContentLoaded', function(){
    document.querySelector('select[name="display_order"]').addEventListener('change', function(){
        let value = document.querySelector('select[name="display_order"]').value;

        let urlParser = new URL(window.location.href);
        if(urlParser.searchParams.get('displayOrder')){
            urlParser.searchParams.set('displayOrder', value);
        } else {
            urlParser.searchParams.append('displayOrder', value);
        }

        if(urlParser.searchParams.get('paged')){
            urlParser.searchParams.delete('paged');
        }
        window.location.href = urlParser.toString();
    });
});