<?php
defined( 'ABSPATH' ) || exit;

if(tw_is_plugin_active('woocommerce/woocommerce.php')) {
    function tw_customize_woocommerce_product_metaboxes()
    {
        add_action('add_meta_boxes', function(){
            remove_meta_box(
                'woocommerce-product-data',
                'product',
                'normal'
            );

            add_meta_box(
                'woocommerce-product-data',
                __( 'Product data', 'woocommerce' ),
                function($post){
                    $metaboxContent = '';

                    ob_start();
                    WC_Meta_Box_Product_Data::output($post);
                    $metaboxContent = ob_get_contents();
                    ob_end_clean();

                    $metaboxContent = apply_filters('tw_woocommerce_metabox_content', $metaboxContent);
                    echo $metaboxContent;
                },
                'product',
                'normal',
                'high'
            );
        }, PHP_INT_MAX);

        add_filter('tw_woocommerce_metabox_content', function($metaboxContent){
            $product = null;
            if(
                isset($_GET['action']) && $_GET['action'] == 'edit'
                && isset($_GET['post'])
            ) {
                $post = get_post($_GET['post']);
                if($post->post_type == 'product' && !empty(wc_get_product($_GET['post']))){
                    $product = wc_get_product($_GET['post']);
                }
            }

            $html5Parser = new Masterminds\HTML5(array(
                'disable_html_ns' => true,
            ));
            $document = $html5Parser->loadHTML($metaboxContent);

            $xpath = new DOMXPath($document);
            $fnToggleTabContent = function($children, $action = 'hide') {
                if(!is_array($children) && get_class($children) == "DOMElement") {
                    $children = [$children];
                }

                foreach ($children as $node) {
                    $class = $node->getAttribute('class');
                    if($action == 'hide' && strchr($class, 'hidden') === false) {
                        $class .= ' hidden';
                    } else if($action != 'hide') {
                        $class = str_replace('hidden', '', $class);
                    }
                    $node->setAttribute('class', $class);
                }
            };
            $fnToggleTab = function($children, $action = 'hide') {
                if(!is_array($children) && get_class($children) == "DOMElement") {
                    $children = [$children];
                }

                foreach ($children as $node) {
                    $style = '';
                    if($action == 'hide') {
                        $style = 'display: none;';
                    } else {
                        $style = 'display: block;';
                    }
                    $node->setAttribute('style', $style);
                }
            };

            //hide all tab content and tab title
            $children = $xpath->query('//div[contains(@id, "_data")]');
            $fnToggleTabContent($children, 'hide');

            $container = tw_single_item_or_null($xpath->query('//ul[contains(@class, "_tabs")]'));
            $children = $xpath->query('./li[contains(@class, "_show")]', $container);
            $fnToggleTab($children, 'hide');

            //pre display the correct tab content and tab title based on product data
            $productType = $product !== null ? $product->get_type() : 'simple';
            if($productType == 'simple' || $productType == 'simple-with-variations') {
                $children = tw_single_item_or_null($xpath->query('//div[contains(@id, "general_product_data")]'));
                $fnToggleTabContent($children, 'reveal');

                $container = tw_single_item_or_null($xpath->query('//div[contains(@id, "general_product_data")]'));
                $children = $xpath->query('//div[contains(@class, "show_if_external")]', $container);
                $fnToggleTabContent($children, 'hide');

                $container = tw_single_item_or_null($xpath->query('//ul[contains(@class, "_tabs")]'));
                $children = $xpath->query('./li[contains(@class, "show_if_simple")]', $container);
                $fnToggleTab($children, 'reveal');

                $container = tw_single_item_or_null($xpath->query('//div[contains(@id, "general_product_data")]'));
                
                //hide date field if not needed
                $dateField = $xpath->query('//*[contains(@class, "sale_price_dates_fields")]', $container);
                $fnToggleTab($dateField, 'hide');

                $children = $xpath->query('./div[contains(@class, "show_if_simple")]', $container);
                if($productType == 'simple-with-variations' || $productType == 'simple')
                {
                    foreach($children as $elem) {
                        $class = $elem->getAttribute('class');
                        $class .= " show_if_simple-with-variations";
                        $elem->setAttribute('class', $class);
                    }
                }
                $fnToggleTabContent($children, 'reveal');
            } else if($productType == 'external') {
                //nothing to do
            }

            $metaboxContent = $html5Parser->saveHTML($document);
            return $metaboxContent;
        });
    }

    add_action('admin_init', 'tw_customize_woocommerce_product_metaboxes', PHP_INT_MAX);

    add_filter('woocommerce_product_data_tabs', function($tabs){
        $tabs['general']['class'] = array('show_if_simple', 'show_if_variable', 'show_if_grouped', 'show_if_external', 'show_if_simple-with-variations');
        $tabs['inventory']['class'] = array('show_if_simple', 'show_if_variable', 'show_if_grouped', 'show_if_simple-with-variations');
        return $tabs;
    }, PHP_INT_MAX );
}