<?php
defined( 'ABSPATH' ) || exit;

/**
 *  TODO inclure une vérification des capabilities
 */
if(tw_is_plugin_active('woocommerce/woocommerce.php')){
    add_action('init', function(){
        if(is_admin()){
            require_once ABSPATH . '/wp-content/plugins/tw-core/classes/tw_stock_list_table.php';

            $menu_icon = plugin_dir_path(__DIR__) . 'icon/hands-shake-money.svg';
            $parsed_url = tw_parse_url($_SERVER['REQUEST_URI']);
            $current_page_is_plugin_page = false;
            if(isset($parsed_url['params']['page']) 
                && preg_match('/^tw-core-stock-page/', $parsed_url['params']['page']) !== false
            ) {
                $current_page_is_plugin_page = true;
            }

            if($current_page_is_plugin_page) {
                $menu_icon = tw_svg_file_to_uri($menu_icon, '#ffffff');
            } else {
                $menu_icon = tw_svg_file_to_uri($menu_icon);
            }
            
            add_menu_page(
                __('Liste des stocks', 'tw-core-stock-page'),
                __('Liste des stocks', 'tw-core-stock-page'),
                'manage_options',
                'tw-core-stock-page',
                function(){
                    $currentScreen = convert_to_screen('tw-core-stock-page');
                    $currentScreen->post_type = 'product';

                    $listTable = new TW_Stock_List_Table([
                        'screen' => $currentScreen
                    ]);
                    $listTable->prepare_items();

                    $plugin_url = plugin_dir_url(dirname(__FILE__));

                    echo '<script type="text/javascript" src="' . $plugin_url . '/js/admin_stock_management_form.js"></script>';
                    echo '<div class="wrap">';
                    echo '<form name="tw_stock_management_form" method="POST">';
                    echo '<h1 class="wp-heading-inline">Gestion des stocks</h1>';
                    echo '<button style="margin-left:10px;" class="page-title-action" type="submit">Modifier</button>';

                    echo $listTable->display();
                    echo '</form>';
                    echo '</div>';
                },
                $menu_icon,
                3
            );
        }
    });

    add_action('init', function(){
        $parsed_url = tw_parse_url($_SERVER['REQUEST_URI']);
        if($_SERVER['REQUEST_METHOD'] == 'POST' && $parsed_url['is_admin'] && isset($parsed_url['params']['page']) && $parsed_url['params']['page'] == 'tw-core-stock-page') {
            $updated_product_ids = [];
            if(isset($_POST['post']) && !empty($_POST['post'])){
                $updated_product_ids = array_values($_POST['post']);
            }

            if(count($updated_product_ids) > 0) {
                foreach($updated_product_ids as $product_id) {
                    if(isset($_POST['stock_quantity_' . $product_id]) 
                    && !empty($_POST['stock_quantity_' . $product_id])
                    && filter_var($_POST['stock_quantity_' . $product_id], FILTER_VALIDATE_INT) !== false){
                        $product = wc_get_product($product_id);

                        if($product->get_stock_management_mode() == 'dedicated_stock_managed_by_woocommerce') {
                            $new_stock = (int)$_POST['stock_quantity_' . $product_id];

                            $product->set_stock_quantity($new_stock);
                            $product->save();
                        }
                    }
                }
                wp_admin_notice(__('Stock mis à jour', 'tw-core'), array(
                    'additional_classes' => array('notice-success', 'success'),
                    'dismissible' => true
                ));
            }
        }
    }, PHP_INT_MAX);
}

