<?php
defined( 'ABSPATH' ) || exit;

add_filter('woocommerce_product_data_tabs', function($tabs){
    global $product_object;
    if(isset($tabs['variations'])){
        unset($tabs['variations']);
    }

    $tabs['variations'] = array(
        'label' => __('Variations', 'woocommerce'),
        'target' => 'product_simple_with_variations',
        'class' => array('show_if_simple-with-variations'),
        'priority' => 15
    );

    return $tabs;
}, PHP_INT_MAX - 1);

add_action('woocommerce_product_data_panels', function() {
    global $product_object;
    include dirname(__DIR__)  . '/templates/variations_tab_fields.php';
}, PHP_INT_MAX);

add_action('woocommerce_admin_process_product_object', function(WC_Product $product){
    if($product instanceof TW_Product_Variable
        && (isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] == 'POST' && get_current_screen()->id == 'product')
    ) {
        $variable_products = isset($_POST['variable_products']) ? $_POST['variable_products'] : [];
        $product->set_variation_data($variable_products);   
    }
});

add_action("wp_ajax_tw_core_list_product_variable", function(){
    $results = [];
    $term = isset($_GET['term']) ? trim($_GET['term']) : "";

    $query_args = [
        'type' => 'simple-with-variations',
        'orderby' => array( 'title' => 'ASC'),
        'posts_per_page' => 30,
        'cache_results' => false
    ];
    if($term != '') {
        $query_args['search_parameters_override'] = [
            'term' => $term,
            'criteria' => 'LIKE',
            'column' => 'post_title'
        ];
    }

    $query = new WC_Product_Query($query_args);
    $products = $query->get_products();
    foreach($products as $product) {
        $results[] = [
            'id' => $product->id,
            'text' => $product->name
        ];
    }

    echo json_encode([
        'status' => 'OK',
        'results' => $results
    ]);
    die;
});

add_action('woocommerce_after_product_object_save', function(WC_Product $product, $product_store){
    if($product instanceof TW_Product_Variable) {
        $product->save_variation_data();
    }
}, PHP_INT_MAX, 2);


//TODO PROBLEME EDITED POST TYPE

add_action('admin_init', function(){
    $js_url = plugin_dir_url(__DIR__) . 'js/product_variable_overload.js';
    tw_enqueue_script(
        'tw_core_product_variable_overload', 
        $js_url, 
        array('jquery'),
        null,
        ['']
    );


    $parsed_url = tw_parse_url($_SERVER['REQUEST_URI']);
    if($parsed_url['edited_post_type'] !== null && $parsed_url['edited_post_type'] == 'product'){
        $js_url = plugin_dir_url(__DIR__) . 'js/select2.min.js';
        tw_enqueue_script('select2', $js_url, array());    

        $css_url = plugin_dir_url(__DIR__) . 'css/select2.min.css';
        tw_enqueue_style('select2', $css_url);
    }
}, 10, 0);