<?php

defined( 'ABSPATH' ) || exit;

/**
 * remettre hide_if_grouped dans general
 */
add_filter('woocommerce_product_data_tabs', function($tabs){
    $tabs['supplier'] = array(
        'label' => __('Fournisseur', 'tw_core'),
        'target' => 'product_supplier',
        'class' => array('show_if_simple', 'show_if_variable', 'show_if_simple-with-variations'),
        'priority' => 25
    );
    return $tabs;
}, PHP_INT_MAX - 1);

add_action('woocommerce_product_options_pricing', function(){
    global $product_object;
    if($product_object instanceof TW_Product_Simple || $product_object instanceof TW_Product_Variable) {
        include dirname(__DIR__)  . '/templates/supplier_price_field.php';
    }
});

add_action('woocommerce_product_data_panels', function() {
    include dirname(__DIR__)  . '/templates/supplier_tab.php';
}, PHP_INT_MAX);

add_action('woocommerce_admin_process_product_object', function(WC_Product $product){
    if(
        ($product instanceof TW_Product_Variable || $product instanceof TW_Product_Simple)
        && (isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] == 'POST' && get_current_screen()->id == 'product')
    ) {
        if(isset($_POST['supplier_name'])){
            $id = $product->get_id();
            $supplier_data = [
                'product_id' => $product->get_id(),
                'supplier_name' => (isset($_POST['supplier_name']) && trim($_POST['supplier_name']) != '') ? $_POST['supplier_name'] : null,
                'restocking_delay' => (isset($_POST['restocking_delay']) && trim($_POST['restocking_delay']) != '') ? $_POST['restocking_delay'] : null,
                'manage_restocking' => (isset($_POST['manage_restocking']) && trim($_POST['manage_restocking']) ==  1) ? true : false,
                'supplier_restocking_url' => (isset($_POST['supplier_restocking_url']) && trim($_POST['supplier_restocking_url']) != '') ? $_POST['supplier_restocking_url'] : '',
            ];
            
           $product->set_supplier_data($supplier_data);
        } 
        
        if(isset($_POST['supplier_price'])){
            $product->set_supplier_price($_POST['supplier_price']);
        }
    }
});

function tw_woocommerce_after_product_object_save(WC_Product $product, $product_store)
{
    if($product instanceof TW_Product_Simple || $product instanceof TW_Product_Variable) {
        $product->save_supplier_data();
        $product->save_supplier_price();
    }
}
add_action('woocommerce_after_product_object_save', 'tw_woocommerce_after_product_object_save', PHP_INT_MAX, 2);