<?php
defined( 'ABSPATH' ) || exit;

if(tw_is_plugin_active('woocommerce/woocommerce.php') || tw_is_test_environment()){
    add_action('woocommerce_product_options_sku', function(){
        global $product_object;
        include dirname(__DIR__)  . '/templates/inventory_stock_fields.php';
    }, PHP_INT_MAX, 0);

    add_action('woocommerce_product_options_inventory_product_data', function(){
        global $product_object;
        include dirname(__DIR__)  . '/templates/inventory_backorder_fields.php';
    }, PHP_INT_MAX, 0);

    add_action('woocommerce_admin_process_product_object', function(WC_Product $product){
        if(
            ($product instanceof TW_Product_Simple || $product instanceof TW_Product_Variable)
            && (isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] == 'POST' && get_current_screen()->id == 'product')
        ) {
            $stock_management_data = null;
            if(isset($_POST['stock_management_mode'])){
                $stock_management_data = [
                    'stock_management_mode' => $_POST['stock_management_mode'],
                    'stock_management_url' => $_POST['stock_management_url']
                ];
            }
            $product->set_stock_management_data($stock_management_data);

            $backorder_limit = null;
            if(isset($_POST['backorder_limit'])){
                $backorder_limit = $_POST['backorder_limit'];
            }
            $product->set_backorder_limit($backorder_limit);
        }
    });

    add_action('woocommerce_after_product_object_save', function(WC_Product $product, $product_store){
        if($product instanceof TW_Product_Simple || $product instanceof TW_Product_Variable) {
            $product->save_stock_management_data();
            $product->save_backorder_limit();

            if($product->get_manage_stock() == false && $product->get_stock_management_mode() != 'dedicated_stock_managed_by_woocommerce') {
                $product_store->update_product_stock($product->get_id(), $product->get_stock_quantity());
                /*
                $product_store_class_name = new Product_Stock()

                //$product_store->update_product_stock($product->get_id(), $product->get_stock_quantity());
                $reflector = new ReflectionClass('WC_Product_Data_Store_Interface');
                $reflectorMethod = $reflector->getMethod('set_product_stock');
                $reflectorMethod->setAccessible(true);
                $reflectorMethod->invoke($product_store, $product->get_id(), $product->get_stock_quantity());
                $reflectorMethod->setAccessible(false);
                */
            }
        }
    }, PHP_INT_MAX, 2);

    
    /*
    add_filter('tw_has_enough_stock', function($has_enough_stock, $quantity, WC_Product $product){
        return tw_check_if_stock_is_enough($quantity, $product);
    });

    function tw_check_if_stock_is_enough($quantity, WC_Product $product)
    {
    $stock_quantity = $product->get_stock_quantity();

    $required_stock = 0;
    foreach(WC()->cart->get_cart() as $value) {
        if($value['data']->get_id() == $product->get_id()){
            $required_stock = $value['quantity'];
        }
    }

    $current_session_order_id = isset( WC()->session->order_awaiting_payment ) ? absint( WC()->session->order_awaiting_payment ) : absint( WC()->session->get( 'store_api_draft_order', 0 ) );
    $held_stock = wc_get_held_stock_quantity($product, $current_session_order_id);

    if($product->get_backorder_limit() > 0){
            $stock_quantity = $stock_quantity + $product->get_backorder_limit();
    }
    
    return $stock_quantity() < ($held_stock + $required_stock);
    }

    add_filter('woocommerce_product_is_in_stock', function($is_in_stock, WC_Product $product){
        $available_quantity = $product->get_stock_quantity();      
        if($product->get_backorder_limit() > 0) {
            $available_quantity = $available_quantity + $product->get_backorder_limit();
        }

        return $available_quantity > 0;
    });

    add_filter('woocommerce_pay_order_product_has_enough_stock', function($has_enough_stock, WC_Product $product, $values){
        return tw_check_if_stock_is_enough($product->get_stock_quantity(), $product);
    }, PHP_INT_MAX, 3);

    add_filter('woocommerce_cart_item_required_stock_is_not_enough', function($has_enough_stock, WC_Product $product, $values){
    return tw_check_if_stock_is_enough($product->get_stock_quantity(), $product);
    }, PHP_INT_MAX, 3);
    */

    add_action('admin_init', function(){
        $js_url = plugin_dir_url(__DIR__) . 'js/admin_product_form_stock_management.js';
        tw_enqueue_script('tw_core_js_admin_product_form_stock_management', $js_url, array('jquery'));
    }, 10, 0);
}