<?php

if(defined('TW_PRODUCT_SOLD_FORECAST') && TW_PRODUCT_SOLD_FORECAST == true) {
    function schedule_product_forecast(WC_Product $product){
        $repository = TW_Factory::getInstance()->getClass(TW_Task_Repository::class);

        $existingTasksInSameCategory = $repository->getExistingTasks('PROCESS_PRODUCT_SOLD_CURRENT_YEAR');
        $dateToSchedule = new DateTime();
        $dateToSchedule->setTime(19, 0);
        if(count($existingTasksInSameCategory) > 0) {
            $dateToSchedule = DateTime::createFromFormat('Y-m-d H:i:s', $existingTasksInSameCategory[0]['next_execution_date']);
        }

        TW_Task_Manager::getInstance()->scheduleTask(
            'PROCESS_PRODUCT_SOLD_CURRENT_YEAR',
            $product->ID,
            TW_Task_Repository::FREQUENCY_DAILY,
            [],
            $dateToSchedule
        );

        $existingTasksInSameCategory = $repository->getExistingTasks('PROCESS_PRODUCT_SOLD_PREVIOUS_YEAR');
        $dateToSchedule = new DateTime();
        $dateToSchedule->setTime(19, 0);
        if(count($existingTasksInSameCategory) > 0) {
            $dateToSchedule = DateTime::createFromFormat('Y-m-d H:i:s', $existingTasksInSameCategory[0]['next_execution_date']);
        }

        TW_Task_Manager::getInstance()->scheduleTask(
            'PROCESS_PRODUCT_SOLD_PREVIOUS_YEAR',
            $product->ID,
            TW_Task_Repository::FREQUENCY_ONCE,
            [],
            $dateToSchedule
        );
    }

    function remove_product_forecast($productId) {
        $repository = TW_Factory::getInstance()->getClass(TW_Task_Repository::class);
        $repository->deleteTask('PROCESS_PRODUCT_SOLD_CURRENT_YEAR', $productId);
        $repository->deleteTask('PROCESS_PRODUCT_SOLD_PREVIOUS_YEAR', $productId);
    }

    add_action('woocommerce_update_product', function($productId, WC_Product $product){
        schedule_product_forecast($product);
    }, PHP_INT_MAX, 2);

    add_action('woocommerce_new_product', function($productId, WC_Product $product){
        schedule_product_forecast($product);
    }, PHP_INT_MAX, 2);

    add_action('woocommerce_delete_product', function($productId){
        remove_product_forecast($productId);
    }, PHP_INT_MAX, 1);
}