<?php

defined( 'ABSPATH' ) || exit;

function tw_product_cart_update_quantity()
{
    $cart_item_key = isset($_POST['cart_item_key']) ? $_POST['cart_item_key'] : null;
    $quantity = isset($_POST['quantity']) ? $_POST['quantity'] : null;

    if($cart_item_key !== null && $quantity !== null) {
        WC()->cart->set_quantity($cart_item_key, $quantity, true);
        wp_send_json(['STATUS' => 'OK'], 200);
        die;
    }

    wp_send_json(['STATUS' => 'ERROR'], 401);
    die;
}

add_action('init', function(){
    if(tw_is_plugin_active('woocommerce/woocommerce.php')) {
        add_action('wp_ajax_update_product_cart_quantity', 'tw_product_cart_update_quantity');
        add_action('wp_ajax_nopriv_update_product_cart_quantity', 'tw_product_cart_update_quantity');

        add_action('wp_loaded', function(){
            if($_SERVER['REQUEST_METHOD'] == 'POST'
                && isset($_REQUEST['add-to-cart'])
                && !empty($_REQUEST['add-to-cart'])
                && isset($_REQUEST['add-to-cart-method'])
                && $_REQUEST['add-to-cart-method'] == 'tw-ajax-add-to-cart'
            ) {
                wp_send_json(['STATUS' => 'OK'], 200);
                die;
            }
        }, PHP_INT_MAX);
    }
});