<?php

defined( 'ABSPATH' ) || exit;

add_filter('wc_order_statuses', function($order_statuses){
    $order_statuses = array_slice($order_statuses, 0, 4, true) +
    array("wc-shipped" => __('Shipped', 'tw-core'), "wc-partially-shipped" => __('Partially shipped', 'tw-core')) +
    array_slice($order_statuses, 4, count($order_statuses), true);

    return $order_statuses;
}, PHP_INT_MAX);

add_filter('woocommerce_register_shop_order_post_statuses', function($post_status){
    $post_status['wc-shipped'] = array(
        'label' => __( 'Shipped', 'tw-core' ),
        'public' => true,
        'exclude_from_search' => false,
        'show_in_admin_all_list' => true,
        'show_in_admin_status_list' => true,
        'label_count' => __('Expédié', 'tw-core')
    );

    $post_status['wc-partially-shipped'] = array(
        'label' => __( 'Partially shipped', 'tw-core' ),
        'public' => true,
        'exclude_from_search' => false,
        'show_in_admin_all_list' => true,
        'show_in_admin_status_list' => true,
        'label_count' => __('Partiellement ', 'tw-core')
    );

    return $post_status;
}, PHP_INT_MAX);


add_filter('woocommerce_shop_order_list_table_default_statuses', function($statuses){
    $statuses[] = 'wc-partially-shipped';   
    return $statuses;
});

/*
add_filter('bulk_actions-woocommerce_page_wc-orders', function($actions){
    $test = wc_get_order(1436);
    $item = $test->get_items()[1905];

    $actions = array_slice($actions, 0, 3, true) + 
    array('mark_shipped' => __('Change status to shipped', 'tw-core')) +
    array_slice($actions, 3, count($actions), true);

    return $actions;
}, PHP_INT_MAX);
*/


add_action('woocommerce_payment_complete', function($order_id, $transaction_id){
    $needs_shipping = false;
    $order = wc_get_order($order_id);

    foreach($order->get_items() as $item) {
        $product = wc_get_product($item->get_product_id());
        if($product->needs_shipping()) {
            $needs_shipping = true;
        }
    }

    if($needs_shipping == false) {
        $order->update_status("shipped");
    }
}, PHP_INT_MAX, 2);

add_filter( 'bulk_actions-edit-shop_order', 'custom_dropdown_bulk_actions_shop_order', 50, 1 );
function custom_dropdown_bulk_actions_shop_order( $actions ) {
    $new_actions = array();

    // add new order status before processing
    foreach ($actions as $key => $action) {
        if ('mark_processing' === $key)
            $new_actions['mark_shipped'] = __( 'Change status to shipped', 'woocommerce' );

        $new_actions[$key] = $action;
    }
    return $new_actions;
}

/*
// Register a custom order status
add_action('init', 'register_custom_order_statuses');
function register_custom_order_statuses() {
    register_post_status('wc-shipped ', array(
        'label' => __( 'Shipped', 'woocommerce' ),
        'public' => true,
        'exclude_from_search' => false,
        'show_in_admin_all_list' => true,
        'show_in_admin_status_list' => true,
        'label_count' => _n_noop('Shipped <span class="count">(%s)</span>', 'Shipped <span class="count">(%s)</span>')
    ));
}


// Add a custom order status to list of WC Order statuses
add_filter('wc_order_statuses', 'add_custom_order_statuses');
function add_custom_order_statuses($order_statuses) {
    $new_order_statuses = array();

    // add new order status before processing
    foreach ($order_statuses as $key => $status) {
        $new_order_statuses[$key] = $status;
        if ('wc-processing' === $key) {
            $new_order_statuses['wc-shipped'] = __('Shipped', 'woocommerce' );
        }
    }
    return $new_order_statuses;
}


// Adding custom status 'awaiting-delivery' to admin order list bulk dropdown
add_filter( 'bulk_actions-edit-shop_order', 'custom_dropdown_bulk_actions_shop_order', 50, 1 );
function custom_dropdown_bulk_actions_shop_order( $actions ) {
    $new_actions = array();

    // add new order status before processing
    foreach ($actions as $key => $action) {
        if ('mark_processing' === $key)
            $new_actions['mark_shipped'] = __( 'Change status to shipped', 'woocommerce' );

        $new_actions[$key] = $action;
    }
    return $new_actions;
}

// Add a custom order status action button (for orders with "processing" status)
add_filter( 'woocommerce_admin_order_actions', 'add_custom_order_status_actions_button', 100, 2 );
function add_custom_order_status_actions_button( $actions, $order ) {
    // Display the button for all orders that have a 'processing', 'pending' or 'on-hold' status
    if ( $order->has_status( array( 'on-hold', 'processing', 'pending' ) ) ) {

        // The key slug defined for your action button
        $action_slug = 'shipped';

        // Set the action button
        $actions[$action_slug] = array(
            'url'       => wp_nonce_url( admin_url( 'admin-ajax.php?action=woocommerce_mark_order_status&status='.$action_slug.'&order_id='.$order->get_id() ), 'woocommerce-mark-order-status' ),
            'name'      => __( 'Shipped', 'woocommerce' ),
            'action'    => $action_slug,
        );
    }
    return $actions;
}

// Set styling for custom order status action button icon and List icon
add_action( 'admin_head', 'add_custom_order_status_actions_button_css' );
function add_custom_order_status_actions_button_css() {
    $action_slug = "shipped"; // The key slug defined for your action button
    ?>
    <style>
        .wc-action-button-<?php echo $action_slug; ?>::after {
            font-family: woocommerce !important; content: "\e029" !important;
        }
    </style>
    <?php
}
*/