<?php

defined( 'ABSPATH' ) || exit;

if(tw_is_plugin_active('woocommerce/woocommerce.php')){
    add_action('woocommerce_admin_order_item_headers', function($order){
        echo '<th class="">' . __('Quantité a expédier', 'tw-core') . '</th>';
        echo '<th class="">' . __('Quantité en stock', 'tw-core') . '</th>';
    }, PHP_INT_MAX);
    
    add_action('woocommerce_admin_order_item_values', function(?WC_Product $product, $item, $item_id){
        if(is_a($item, 'WC_Order_Refund')){
            return;
        }

        $order_id = $item->get_order_id();
        $ordered_quantity = (int)$item->get_quantity();
        $allready_shipped_quantity = TW_Factory::getInstance()->getClass(TW_Shipping_Repository::class)->getShippedQuantityForOrderItem(
            $order_id,
            $item_id
        );
        $quantity_to_ship = $ordered_quantity - $allready_shipped_quantity;

        if($product !== null) {
            $product_stock = $product->get_stock_quantity();
            if($product->get_() != "dedicated_stock_managed_by_woocommerce"){
                $stocks = TW_External_Stock_Manager::getInstance()->getProductStocks([$product], false);
                if(isset($stocks[$product->get_id()])){
                    $product_stock = $stocks[$product->get_id()];
                }
            }

            $reducedStock = $item->get_meta('_reduced_stock', true);
            if($product->get_stock_management_mode() != "dedicated_stock_managed_by_woocommerce" && !empty($reducedStock) && filter_var($reducedStock, FILTER_VALIDATE_INT) !== false){
                $product_stock = $product_stock + (int)$reducedStock;
            }

            echo '<td>'  . $quantity_to_ship .  '</td>';
            
            if($product_stock !== null) {
                $product_stock = (int)$product_stock;
                if($product_stock < $quantity_to_ship) {
                    echo '<td><span style="color:red;">' . $product_stock . '</span></td>';
                } else {
                    echo '<td>' . $product_stock . '</td>'; 
                }
            }  else {
                echo '<td>-</td>';
            }
        } else {
            echo '<td>'  . $quantity_to_ship .  '</td>';        
            echo '<td>' . '-' . '</td>';  
        }
    }, PHP_INT_MAX, 3);

    add_action('add_meta_boxes', function(){
        if(get_current_screen()->id == "woocommerce_page_wc-orders" && isset($_GET['action']) && $_GET['action'] == 'edit')
        {
            add_meta_box(
                'tw_order_shipment',
                __('Expédition', 'tw-core'),
                function($object, $box_detail) {
                    $controller = new TW_Shipping_Controller();
                    echo $controller->prepare_metabox();
                },
                'woocommerce_page_wc-orders',
                'normal',
                'high',
                null
            );
        }        
    });

    //remoe colissimo metabox
    add_action('add_meta_boxes', function(){
        $screenId = class_exists('Automattic\\WooCommerce\\Internal\\DataStores\\Orders\\CustomOrdersTableController') && wc_get_container()
            ->get(\Automattic\WooCommerce\Internal\DataStores\Orders\CustomOrdersTableController::class)
            ->custom_orders_table_usage_is_enabled()
            ? wc_get_page_screen_id('shop-order')
            : 'shop_order';

        if(get_current_screen()->id == "woocommerce_page_wc-orders" && isset($_GET['action']) && $_GET['action'] == 'edit')
        {
            remove_meta_box('lpc_banner-box', $screenId, 'high');
        }
    }, PHP_INT_MAX);

    add_action('admin_footer', function(){
        if(get_current_screen()->id == "woocommerce_page_wc-orders" && isset($_GET['action']) && $_GET['action'] == 'edit'){
            $controller = new TW_Shipping_Controller();
            echo $controller->prepare_modal();
        }
    });

    add_action('wp_ajax_tw_add_shipment', function(){
        $controller = new TW_Shipping_Controller();
        $controller->save_shipment_data();
        die;

        /*
        if(get_current_screen()->id == "woocommerce_page_wc-orders" && isset($_GET['action']) && $_GET['action'] == 'tw_add_shipment'){
            $controller = new TW_Shipping_Controller();
            $controller->save_shipment_data();
        }
        */
    });

    /**
     * TODO il faudra enlever la metabox de la poste
     */
}