<?php

defined( 'ABSPATH' ) || exit;

//TODO VOIR wordpress membership.php
function tw_reset_password_form() {
    global $tw_session;

    $templatePath = realpath(get_stylesheet_directory(). '/templates/reset_password_form.php');
    $emailPath =  realpath(get_stylesheet_directory(). '/email/reset_password_email.php');
	
    $data = [];
    $errors = [];
    $templateVars = [];
    if($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['tw_reset_password_form_nonce'])) {
        $data = $_POST;
        if(!isset($_POST['email']) || trim($_POST['email']) == "" || filter_var($_POST['email'], FILTER_VALIDATE_EMAIL) === false){
            $errors['email'] = [__("Ce champ est obligatoire ou mal remplis", "tw")];
        }

        if(!isset($_POST['password']) || trim($_POST['password']) == ""){
            $errors['password'] = [__("Ce champ est obligatoire ou mal remplis", "tw")];
        } else if(strlen($_POST['password']) < 7){
            $errors['password'] = [__("Le mot de passe doit avoir au moins 7 caractères", "tw")];
        }

        if(!isset($_POST['password_confirm']) || trim($_POST['password_confirm']) == "" || trim($_POST['password_confirm']) != trim($_POST['password'])){
            $errors['password_confirm'] = [__("Ce champ est obligatoire ou mal remplis", "tw")];
        }

        if(!wp_verify_nonce($_POST['tw_reset_password_form_nonce'], wp_hash('tw_reset_password_form', 'nonce'))){
            $errors['tw_reset_password_form_nonce'] = [__("Ce champ est obligatoire ou mal remplis", "tw")];
        }

        if(count($errors) == 0) {
            $logging_user = get_user_by('email', $_POST['email']);

            $existing_meta = false;
            $existing_lock = false;
            $nbr_loggin_attempt = 0;

            if($logging_user !== false) {
                if(get_user_meta($logging_user->ID, 'reset_password_token', true) !== false && trim(get_user_meta($logging_user->ID, 'reset_password_token', true)) != '') {
                    $existing_meta = true;
                }

                if(get_user_meta($logging_user->ID, 'nbr_loggin_attempt', true) !== false && trim(get_user_meta($logging_user->ID, 'nbr_loggin_attempt', true)) != '') {
                    $nbr_loggin_attempt = (int)get_user_meta($logging_user->ID, 'nbr_loggin_attempt', true);
                }
            }

            if(defined('TW_MAX_LOGGING_ATTEMPT') && $nbr_loggin_attempt > TW_MAX_LOGGING_ATTEMPT) {
                $existing_lock = true;
            }

            if($existing_lock === true) {
                    $tw_session->set_value('flash', array('notice', 'Suite à de trop nombreuses erreur, votre compte est bloqué, veuillez réessayer ultérieurement'));
                    $_POST = [];
                    header('Location: ' . $_SERVER['REQUEST_URI']);
                    exit();
            } else {
                if($existing_meta === false && $logging_user !== false) {
                    $reset_password_token = $_POST['email'] . '_' . rand(1, 9999);
                    add_user_meta($logging_user->ID, 'reset_password_token', wp_hash($reset_password_token));
                    add_user_meta($logging_user->ID, 'reset_password_timestamp', strtotime('now'));
                    add_user_meta($logging_user->ID, 'reset_password_password', TW_Utils::openssl_encrypt($_POST['password'], true));
    
                    ob_start();
                    load_template($emailPath, false, [
                        'reset_password_link' => get_option('siteurl') . '/reset_password.php' . '?user_id=' . $logging_user->ID . '&token=' . $reset_password_token
                    ]);
                    $emailContent = ob_get_contents();
                    ob_end_clean();
    
                    //send an email
                    wp_mail($_POST['email'], 'Reset password email', $emailContent);

                    $tw_session->set_value('flash', array('notice', 'Email envoyé'));
                    $_POST = [];
                    header('Location: ' . $_SERVER['REQUEST_URI']);
                    exit();
                } else if($existing_meta === true && $logging_user !== false) {
                    $tw_session->set_value('flash', array('error', 'Veuillez vérifier vos emails pour procéder à la réinitialisation'));
                    $_POST = [];
                    header('Location: ' . $_SERVER['REQUEST_URI']);
                    exit();
                }

            }
        }
    }
    $templateVars['data'] = $data;
    $templateVars['errors'] = $errors;

    ob_start();
    load_template($templatePath, false, $templateVars);
    $tplContent = ob_get_contents();
    ob_end_clean();

    return $tplContent;
}
add_shortcode('tw_reset_password_form', 'tw_reset_password_form');

function tw_reset_password_form_redirect() {
    if(isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['tw_reset_password_form_nonce'])) {
        tw_reset_password_form();
    }
}
add_action('wp_loaded', 'tw_reset_password_form_redirect');

function tw_login_form() {
    global $tw_session;
    global $wp_hasher;

    $redirect_authorized_url = get_option('tw_membership_redirect_url') !== false ? get_option('tw_membership_redirect_url') : '/';
    if(!empty($tw_session->get_values()) && isset($tw_session->get_values()['loginRedirectURL'])) {
        $redirect_authorized_url = $tw_session->get_values()['loginRedirectURL'];
    }

    $templatePath = realpath(get_stylesheet_directory(). '/templates/login_form.php');
	
    $data = [];
    $errors = [];
    $templateVars = [];
    if($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['tw_login_form_nonce'])) {
        $data = $_POST;
        if(!isset($_POST['email']) || trim($_POST['email']) == "" || filter_var($_POST['email'], FILTER_VALIDATE_EMAIL) === false){
            $errors['email'] = [__("Ce champ est obligatoire ou mal remplis", "tw")];
        }

        if(!isset($_POST['password']) || trim($_POST['password']) == ""){
            $errors['password'] = [__("Ce champ est obligatoire ou mal remplis", "tw")];
        }

        if(!wp_verify_nonce($_POST['tw_login_form_nonce'], wp_hash('tw_login_form', 'nonce'))){
            $errors['tw_login_form_nonce'] = [__("Ce champ est obligatoire ou mal remplis", "tw")];
        }

        
        //l'utilisateur sera volontairement créer sans role et ne pourra pas se connecter
        //tant que son compte n'aura pas été activé
        if(count($errors) == 0) {
            $logging_user = get_user_by('email', $_POST['email']);

            if($logging_user !== false) {
                $nbr_invalid_login_attempt = 0;
                if(get_user_meta($logging_user->ID, 'nbr_loggin_attempt', true) !== false) {
                    $nbr_invalid_login_attempt = (int)get_user_meta($logging_user->ID, 'nbr_loggin_attempt', true);
                }

                $last_login_attempt = time();
                if(get_user_meta($logging_user->ID, 'last_loggin_attempt', true) !== false) {
                    $last_login_attempt = (int)get_user_meta($logging_user->ID, 'last_loggin_attempt', true);
                }

                $check = wp_check_password($_POST['password'], $logging_user->data->user_pass, $logging_user->ID);
                $waiting_login_timeout = false;
                $remaining_waiting_time = 0;

                if(defined('TW_MAX_LOGGING_ATTEMPT') && $nbr_invalid_login_attempt > TW_MAX_LOGGING_ATTEMPT) {
                    $waiting_time = defined('TW_FAILED_LOGGING_WAITING') ? TW_FAILED_LOGGING_WAITING : 15;
                    if($last_login_attempt + ($waiting_time * 60) > time()) {
                        $waiting_login_timeout = true;
                        $remaining_waiting_time = ($last_login_attempt + ($waiting_time * 60)) - time();
                        $remaining_waiting_time = ceil($remaining_waiting_time / 60);
                    }
                }

                if($waiting_login_timeout === true) {
                    $errors['general'] = [__("Vous devez attendre " . $remaining_waiting_time . " minutes avant de pouvoir de nouveau vous connecter", "tw")];
                } else if(!$check) {
                    $errors['general'] = [__("Aucun utilisateur trouvé avec ce mot de passe", "tw")];

                    $nbr_invalid_login_attempt++;
                    update_user_meta($logging_user->ID, 'nbr_loggin_attempt', $nbr_invalid_login_attempt);
                    update_user_meta($logging_user->ID, 'last_loggin_attempt', time());
                } else {
                    $nbr_invalid_login_attempt = 0;
                    update_user_meta($logging_user->ID, 'nbr_loggin_attempt', $nbr_invalid_login_attempt);
                    update_user_meta($logging_user->ID, 'last_loggin_attempt', time());


                    wp_clear_auth_cookie();
                    wp_set_current_user($logging_user->ID);
                    wp_set_auth_cookie($logging_user->ID);
                    wp_safe_redirect($redirect_authorized_url, 307);

                    $tw_session->set_value('flash', array('notice', __("notice.loginOK", "tw-theme")));
                    $_POST = [];
                    header('Location: ' . $redirect_authorized_url, true);
                    exit();
                }
            } else {
                $errors['general'] = [__("Aucun utilisateur trouvé avec ce mot de passe", "tw")];
            }
        }
    }
    $templateVars['data'] = $data;
    $templateVars['errors'] = $errors;

    ob_start();
    load_template($templatePath, false, $templateVars);
    $tplContent = ob_get_contents();
    ob_end_clean();

    return $tplContent;
}
add_shortcode('tw_login_form', 'tw_login_form');

function tw_login_form_redirect() {
    if(isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['tw_login_form_nonce'])) {
        tw_login_form();
    }
}
add_action('wp_loaded', 'tw_login_form_redirect');