<?php

defined( 'ABSPATH' ) || exit;

add_action('phpmailer_init', function(\PHPMailer\PHPMailer\PHPMailer $phpmailer){
    $phpmailer->IsSMTP();
    if(
        !defined('SMTP_SERVER')
        || !defined('SMTP_PORT')
        || !defined('SMTP_USERNAME')
        || !defined('SMTP_PASSWORD')
    ) {
        return;
    }

    if(defined('SMTP_AUTHENTICATION') && SMTP_AUTHENTICATION != 'NONE') {
        $phpmailer->SMTPAuth = true;
        $phpmailer->Host = SMTP_SERVER;
        $phpmailer->Port = SMTP_PORT;
        $phpmailer->Username = SMTP_USERNAME;
        $phpmailer->Password = SMTP_PASSWORD;

        if(defined('SMTP_ENCRYPTIONTYPE') && SMTP_ENCRYPTIONTYPE) {
            $phpmailer->SMTPSecure = SMTP_ENCRYPTIONTYPE;
        }
    } else {
        $phpmailer->SMTPAuth = false;
        $phpmailer->Host = SMTP_SERVER;
        $phpmailer->Port = SMTP_PORT;
    }
}, PHP_INT_MAX -1);

add_action('phpmailer_init', function(\PHPMailer\PHPMailer\PHPMailer $phpmailer){
    if(defined('MAIL_FROM') && !empty(MAIL_FROM)){
        list($namePart, $emailPart) = tw_parse_name_and_address_from_mail_header(MAIL_FROM);
        if($emailPart !== null && filter_var($emailPart, FILTER_VALIDATE_EMAIL) !== false) {
            $namePart = $namePart === null ? '' : $namePart;
            $phpmailer->setFrom($emailPart, $namePart, false);
        }
    }

    if(defined('REPLY_TO') && !empty(REPLY_TO)){
        list($namePart, $emailPart) = tw_parse_name_and_address_from_mail_header(REPLY_TO);
        if($emailPart !== null && filter_var($emailPart, FILTER_VALIDATE_EMAIL) !== false) {
            $namePart = $namePart === null ? '' : $namePart;
            $phpmailer->clearReplyTos();
            $phpmailer->addReplyTo($emailPart, $namePart);
        }
    }
}, PHP_INT_MAX);

add_filter('wp_mail_content_type', function(){
    return "text/html";
});

add_filter('wp_mail', function($args){
    //définit to si args['to'] n' a pas été spécifiée
    if(defined('REPLY_TO') && !empty(REPLY_TO) && is_string($args['to']) && trim($args['to']) == '') {
        $args['to'] =  REPLY_TO;
    }

    return $args;
}, PHP_INT_MAX);