<?php

defined( 'ABSPATH' ) || exit;

if(defined('WP_DEBUG') && WP_DEBUG == true) {
    if(isset($GLOBALS['tw_post_types'])) {
        foreach($GLOBALS['tw_post_types'] as $postTypeKey => $postTypeDetail) {
            $encoded = null;
            try {
                $encoded = json_encode($postTypeDetail);
                $encoded = hash('sha256', $encoded);
            } catch (\Exception $ex) {}

            $flushedPostType = get_option('tw_post_type_' . strtolower($postTypeKey), false);
            if($flushedPostType === false || $encoded != $flushedPostType) {
                add_action('wp_body_open', function() use ($postTypeKey){
                    echo '<p style="color:red;">rewrite rules ' . $postTypeKey . ' not flushed do it with wp tw_flush_command flush</p>';
                }, PHP_INT_MAX, 1);
                
                add_action('admin_notices', function() use ($postTypeKey){
                    echo '<p style="color:red;">rewrite rules ' . $postTypeKey . ' not flushed do it wp tw_flush_command flush</p>';
                }, PHP_INT_MAX, 1);
            }
        }
    }
}