<?php

defined( 'ABSPATH' ) || exit;

function tw_add_flash_script() {
    if(isWpCronOrWpCli() === false) {
        $directory_url = get_bloginfo('url') . '/wp-content/plugins/tw-core';

        //pnotify
        $script_url = $directory_url . '/js/pnotify.min.js';
        wp_enqueue_script('pnotify', $script_url, [], false, true);

        $script_url = $directory_url . '/js/pnotifymobil.min.js';
        wp_enqueue_script('pnotifymobil', $script_url, [], false, true);

        wp_add_inline_script('pnotify', "
            window.unpositionedStack = new PNotify.Stack({
                maxOpen: Infinity,
                modal: false,
                positioned: false,
                context: document.getElementById('tw-notices-wrapper')
            });
        ");

        $css_url = $directory_url . '/css/pnotify.min.css';
        wp_enqueue_style('pnotify', $css_url, [], false);

        $css_url = $directory_url . '/css/pnotifymobil.min.css';
        wp_enqueue_style('pnotifymobil', $css_url, [], false);

        $css_url = $directory_url . '/css/pnotifybright.css';
        wp_enqueue_style('pnotifybright', $css_url, [], false);
    }
}
add_action('wp', 'tw_add_flash_script', PHP_INT_MAX);

function tw_display_flash($locationManager) {
    global $tw_session;
    $script_to_append = null;

    $session_values = $tw_session->get_values();
    if(isset($session_values['flash'])){
        $session_values = $tw_session->get_values();
        if(isset($session_values['flash'])) {
            $tw_session->remove_value('flash');

            $flash = $session_values['flash'];
            $flash_type = $flash[0];
            $flash_message = $flash[1];

            if($flash_type == 'notice') {
                $script_to_append .= "
                    jQuery(document).ready(function(){
                        PNotify.alert({
                            text: \"{$flash_message}\",
                            stack: window.unpositionedStack, 
                            hide: true 
                        });
                    });
                ";
            } else if($flash_type == 'error') {
                $script_to_append .= "
                    jQuery(document).ready(function(){
                        PNotify.error({
                            text: \"{$flash_message}\",
                            stack: window.unpositionedStack,
                            hide: false 
                        });
                    });
                ";
            }
        }
    }

    echo '<script type="text/javascript">' . $script_to_append . '</script>';
    echo '<div class="notices-wrapper site-main" id="tw-notices-wrapper"></div>';
}

//Locations_Manager ligne 388
add_action('elementor/theme/after_do_header', 'tw_display_flash', PHP_INT_MAX, 1);