<?php

defined( 'ABSPATH' ) || exit;


if(tw_is_plugin_active('woocommerce/woocommerce.php') || tw_is_test_environment()){

    //if($product->get_stock_management_mode() != 'dedicated_stock_managed_by_woocommerce'){
    function _tw_availability_stock_and_class(WC_Product $product){
        $availabilityText = null;
        $availabilityClass = null;

        $productId = $product->get_id();

        $availableQuantity = $product->get_stock_quantity() !== null ? $product->get_stock_quantity() : 0;
        $stocks = TW_External_Stock_Manager::getInstance()->getProductStocks([$product], false);
        if(isset($stocks[$productId])){
            $availableQuantity = $stocks[$productId];
            $product->set_stock_quantity($availableQuantity);
        }

        $backorderLimit = $product->get_backorder_limit();
        if($availableQuantity < 1) {
            if($backorderLimit !== null && $backorderLimit > abs($availableQuantity)) {
                $availabilityText = __('Available on backorder', 'woocommerce');
                $availabilityClass = 'available-on-backorder';
            } else {
                $availabilityText = __( 'Out of stock', 'woocommerce');
                $availabilityClass = 'out-of-stock';
            }
        } else {
            $availabilityText = wc_format_stock_for_display($product);
            $availabilityClass = 'in-stock';
        }

        return [$availabilityText, $availabilityClass];
    }

    function tw_stock_get_availability_text($availabilityText, WC_Product $product) 
    {
        list($availabilityText, $availabilityClass) = _tw_availability_stock_and_class($product);
        $availabilityText = $availabilityText;
        return $availabilityText;
    }

    //hook responsable affichage du texte
    add_filter('woocommerce_get_availability_text', 'tw_stock_get_availability_text', PHP_INT_MAX -1, 2);
    
    add_filter('woocommerce_get_availability_class', function($availabilityClass, WC_Product $product){
        list($availabilityText, $availabilityClass) = _tw_availability_stock_and_class($product);
        $availabilityClass = $availabilityClass;
        return $availabilityClass;
    }, PHP_INT_MAX -1, 2);

    //hook responsable affichage du bouton
    /*
    function tw_stock_product_is_in_stock($instock, WC_Product $product)
    {
        $hasEnoughStock = $product->get_stock_quantity() > 0;
        $productId = $product->get_id();

        if($product->get_stock_management_mode() != 'dedicated_stock_managed_by_woocommerce'){
            $hasEnoughStock = true;
            $stocks = TW_External_Stock_Manager::getInstance()->getProductStocks([$product], false);
            $availableQuantity = isset($stocks[$productId]) ? $stocks[$productId] : $product->get_stock_quantity();

            $backorderLimit = $product->get_backorder_limit();
            if($availableQuantity < 1 && $backorderLimit === null) {
                $hasEnoughStock = false;
            } else if($availableQuantity < 1 && $backorderLimit !== null && $backorderLimit <= abs($availableQuantity)) {
                $hasEnoughStock = false;
            }
        }   

        return $hasEnoughStock;
    }
    */
    
    function tw_stock_product_is_in_stock($stock_status, WC_Product $product) {
        if($stock_status != true 
            && $product->get_stock_management_mode() == 'dedicated_stock_managed_by_woocommerce'
            && $product->get_backorders()
        ) {
            $stock_quantity = $product->get_stock_quantity();
            $backorder_quantity = $product->get_backorder_limit();

            if(($stock_quantity + $backorder_quantity) > 0) {
                $stock_status = true;
            }
        } else {
            $productId = $product->get_id();
            $stocks = TW_External_Stock_Manager::getInstance()->getProductStocks([$product], false);
            $availableQuantity = isset($stocks[$productId]) ? $stocks[$productId] : $product->get_stock_quantity();
            $backorderLimit = $product->get_backorder_limit();

            $stock_status = true;
            if($availableQuantity < 1 && $backorderLimit === null) {
                $stock_status = false;
            } else if($availableQuantity < 1 && $backorderLimit !== null && $backorderLimit <= abs($availableQuantity)) {
                $stock_status = false;
            }
        }

        return $stock_status;
    }
    add_filter('woocommerce_product_is_in_stock', 'tw_stock_product_is_in_stock', PHP_INT_MAX, 2);

    /*
    add_filter('woocommerce_product_is_in_stock', function($stock_status, WC_Product $product){
        if($stock_status != true 
            && $product->get_stock_management_mode() == 'dedicated_stock_managed_by_woocommerce'
            && $product->get_backorders()
        ) {
            $stock_quantity = $product->get_stock_quantity();
            $backorder_quantity = $product->get_backorder_limit();

            if(($stock_quantity + $backorder_quantity) > 0) {
                $stock_status = true;
            }
        } else {
            $productId = $product->get_id();
            $stocks = TW_External_Stock_Manager::getInstance()->getProductStocks([$product], false);
            $availableQuantity = isset($stocks[$productId]) ? $stocks[$productId] : $product->get_stock_quantity();
            $backorderLimit = $product->get_backorder_limit();

            $stock_status = true;
            if($availableQuantity < 1 && $backorderLimit === null) {
                $stock_status = false;
            } else if($availableQuantity < 1 && $backorderLimit !== null && $backorderLimit <= abs($availableQuantity)) {
                $stock_status = false;
            }
        }

        return $stock_status;
    }, PHP_INT_MAX, 2);
    */

    add_filter('tw_has_enough_stock', function($has_enough_stock, $quantity, WC_Product $product){
        if($product->get_stock_management_mode() == 'dedicated_stock_managed_by_woocommerce'
            && $product->get_stock_quantity() < $quantity
            && $product->get_backorders()) {
            
            if($product->get_backorder_limit() + $product->get_stock_quantity() >= $quantity){
                $has_enough_stock = true;
            }
        }
        return $has_enough_stock;
    }, PHP_INT_MAX, 3);
    
    /**
     *  dans WC_Checkout la gestion des held stocks n'arrive qu'à partir de l'ajout dans le panier
     */
    function tw_add_to_cart_quantity($quantity, $productId)
    {
        $product = wc_get_product($productId);
        $availableQuantity = $product->get_stock_quantity();
        $backorderLimit = 0;
        $backorderLimit = $product->get_backorder_limit();

        if($product->get_stock_management_mode() != 'dedicated_stock_managed_by_woocommerce'){
            $stocks = TW_External_Stock_Manager::getInstance()->getProductStocks([$product], true);
            $availableQuantity = isset($stocks[$productId]) ? $stocks[$productId] : 0;
        }

        $heldStock = wc_get_held_stock_quantity($product);
        if(filter_var($heldStock, FILTER_VALIDATE_INT) !== false) {
            $heldStock = filter_var($heldStock, FILTER_VALIDATE_INT);
            if($heldStock > 0) {
                $availableQuantity = $availableQuantity - $heldStock;
            }
        }

        if($backorderLimit > 0) {
            $availableQuantity = $availableQuantity + $backorderLimit;
        }

        if($availableQuantity < 1) {
            throw new Exception(sprintf( __( 'You cannot add &quot;%s&quot; to the cart because the product is out of stock.', 'woocommerce'), $product->get_name())); 
        } else if($availableQuantity < $quantity){
            $quantity = $availableQuantity;
            $message = sprintf( __( 'You cannot add that amount of &quot;%1$s&quot; to the cart because there is not enough stock (%2$s remaining).', 'woocommerce' ), $quantity, $availableQuantity);
            wc_add_notice($message, 'error');
        }

        return $quantity;
    }
    add_filter('woocommerce_add_to_cart_quantity', 'tw_add_to_cart_quantity', PHP_INT_MAX, 2);

    function tw_after_checkout_validation($data, $errors){
        $missingProducts = [];
        $missingProductNames = [];

        foreach(WC()->cart->get_cart() as $values) {
            $product = $values['data'];
            $quantity = (int)$values['quantity'];
            $productId = $product->get_id();

            $availableQuantity = $product->get_stock_quantity();
            $backorderLimit = $product->get_backorder_limit();

            if($product->get_stock_management_mode() != 'dedicated_stock_managed_by_woocommerce'){
                $stocks = TW_External_Stock_Manager::getInstance()->getProductStocks([$product], true);
                $availableQuantity = isset($stocks[$productId]) ? $stocks[$productId] : 0;
                $backorderLimit = $product->get_backorder_limit();
            }

            $heldStock = wc_get_held_stock_quantity($product);
            if(filter_var($heldStock, FILTER_VALIDATE_INT) !== false) {
                $heldStock = filter_var($heldStock, FILTER_VALIDATE_INT);
                if($heldStock > 0) {
                    $availableQuantity = $availableQuantity - $heldStock;
                }
            }

            if($backorderLimit === null && $availableQuantity < $quantity) {
                $missingProducts[] = $product;
                $missingProductNames[] = $product->get_name();
            } else if($backorderLimit !== null && ($availableQuantity + $backorderLimit) < $quantity) {
                $missingProducts[] = $product;
                $missingProductNames[] = $product->get_name();
            }
        }

        if(count($missingProducts) > 0) {
            $errors->add('out-of-stock', sprintf( __( 'Sorry, "%s" is not in stock. Please edit your cart and try again. We apologize for any inconvenience caused.', 'woocommerce' ), implode("", $missingProductNames)));
        }
    }
    add_action('woocommerce_after_checkout_validation', 'tw_after_checkout_validation', PHP_INT_MAX, 2);

    //IL MANQUE TOUTE LA PARTIE SOUMISSION DU STOCK A UNE API
    function tw_reduce_external_stock($order_id)
    {
        $order = wc_get_order($order_id);
        if (!$order) {
		    return;
	    }

        foreach ( $order->get_items() as $item ) {
            if ( ! $item->is_type( 'line_item' ) ) {
                continue;
            }

            $product            = $item->get_product();
            $item_stock_reduced = $item->get_meta( '_reduced_stock', true );

            if ( $item_stock_reduced || ! $product || ! $product->get_stock_management_mode() == 'dedicated_stock_managed_by_woocommerce' ) {
                continue;
            }

            $qty  = apply_filters( 'woocommerce_order_item_quantity', $item->get_quantity(), $order, $item );
            $item->add_meta_data( '_reduced_stock', $qty, true );
            $item->save();
        }
    }
    add_action('woocommerce_payment_complete', 'tw_reduce_external_stock');
    add_action('woocommerce_order_status_completed', 'tw_reduce_external_stock');
    add_action('woocommerce_order_status_processing', 'tw_reduce_external_stock');
    add_action('woocommerce_order_status_on-hold', 'tw_reduce_external_stock');

    function tw_increase_external_stock($order_id)
    {
        $order = wc_get_order($order_id);
        if (!$order) {
		    return;
	    }

        foreach ( $order->get_items() as $item ) {
            if ( ! $item->is_type( 'line_item' ) ) {
                continue;
            }

            $product            = $item->get_product();
            $item_stock_reduced = $item->get_meta( '_reduced_stock', true );

            if ( !$item_stock_reduced || ! $product || ! $product->get_stock_management_mode() == 'dedicated_stock_managed_by_woocommerce' ) {
                continue;
            }

            $item->delete_meta_data( '_reduced_stock');
            $item->save();
        }
    }
    add_action('woocommerce_order_status_cancelled', 'tw_increase_external_stock');
    add_action('woocommerce_order_status_pending', 'tw_increase_external_stock');
}

