<?php

defined( 'ABSPATH' ) || exit;

/**
 * Page order received http://local.boutiquerando2.fr/checkout/order-received/1396/?key=wc_order_SsiKqjb81pr3u
 * après checkout successfull à la place d'utiliser la page de résumé de la commande
 */
add_filter('woocommerce_checkout_customer_id', function($customer_id){
    $posted_data = WC_Checkout::instance()->get_posted_data();

    $existing_user = null;
    if(
        (isset($posted_data['billing_email']) && trim($posted_data['billing_email']) != '')
        && (isset($posted_data['billing_first_name']) && trim($posted_data['billing_first_name']) != '')
        && (isset($posted_data['billing_last_name']) && trim($posted_data['billing_last_name']) != '')
    ) {
        $tmpUser = WP_User::get_data_by('email', $posted_data['billing_email']);
        $tmpUser = ($tmpUser !== false && !empty($tmpUser->ID)) ? new WP_User($tmpUser) : null;

        if($tmpUser !== null
            && $tmpUser->exists()
            && (!empty($tmpUser->get('first_name')) && trim($tmpUser->get('first_name')) == trim($posted_data['billing_first_name']))
            && (!empty($tmpUser->get('last_name')) && trim($tmpUser->get('last_name')) == trim($posted_data['billing_last_name']))
        ){
            $existing_user = $tmpUser;
            $customer_id = $existing_user->ID;
            wp_set_current_user($customer_id);
        }
    }

    return $customer_id;
}, PHP_INT_MAX);

add_filter('woocommerce_registration_error_email_exists', function($message, $data){
    $loginUrl = wc_get_page_permalink('myaccount') . '?redirectTo=checkout';
    $new_link = '<a href="' . $loginUrl . '">' . __("link.shouldlogin","tw-theme") . '</a>';
    $message = preg_replace('/<a href="[^"]*" class="showlogin">.*?<\/a>/', $new_link, $message);
    
    return $message;
}, PHP_INT_MAX, 2);

add_filter('woocommerce_login_redirect', function($redirect, $user){
    if(isset($_GET['redirectTo']) && trim($_GET['redirectTo']) == 'checkout') {
        $redirect = wc_get_checkout_url();
    }

    return $redirect;
}, PHP_INT_MAX, 2);