<?php
defined( 'ABSPATH' ) || exit;

function tw_shipping_methods(){
    global $wpdb;
    $shipping_methods = [];

    $zones = [];
    $shipping_zones = $wpdb->get_results(
        $wpdb->prepare("SELECT * FROM wp_woocommerce_shipping_zone_methods"),
        ARRAY_A
    );

    foreach($shipping_zones as $item) {
        if(!in_array($item['zone_id'], $zones)){
            $zones[] = $item['zone_id'];
        }
    }

    foreach($zones as $zone) {
        $shipping_zone = new WC_Shipping_Zone($zone);
        $methods = $shipping_zone->get_shipping_methods();

        foreach($methods as $method) {
            $shipping_methods[$method->instance_id] = $method;
        }
    }

    return $shipping_methods;
}

function tw_get_account_menu_items(){
    static $filter_applied = false;
    static $static_endpoints = [];
    static $static_items = [];

    if($filter_applied == false) {
        add_filter('woocommerce_account_menu_items', function($items, $endpoints) use (&$static_items, &$static_endpoints){
            $static_items = $items;
            $static_endpoints = $endpoints;

            foreach($static_endpoints as &$individualEndpoint) {
                $individualEndpoint = esc_url(wc_get_account_endpoint_url($individualEndpoint));
            }

            return $endpoints;
        }, PHP_INT_MAX, 2);
    }

    wc_get_account_menu_items();

    $filter_applied = true;
    return [$static_items, $static_endpoints];
}