<?php
use Elementor\Core\DynamicTags\Data_Tag;
use Elementor\Core\DynamicTags\Manager;

defined( 'ABSPATH' ) || exit;

class TW_Custom_Elementor_Tag extends Data_Tag {
    private $className = null;
    private $objectType;
    private $objectSubtype;
    private $propertyName;
    private $fieldType;

    public function __construct($data = [])
    {
        $this->className = get_class($this);
        $this->_parseTagClassname();
    }

    private function _parseTagClassname()
    {
        $parsedClassname = str_replace('TWTAG___', '', $this->className);
        $parsedClassname = explode("___", $parsedClassname);
        $this->objectType = $parsedClassname[0];
        $this->objectSubtype = $parsedClassname[1];
        $this->propertyName = $parsedClassname[2];
        $this->fieldType = $parsedClassname[3];
    }

    public function get_name(){
        return $this->className;
    }

    public function get_title(){
        $title = $this->propertyName;
        if($this->objectSubtype != "product") {
            $title = str_replace($this->objectSubtype, '', $title);
        }
        
        $title = str_replace('tw_', '', $title);
        $title = str_replace('_', ' ', $title);
        $title = trim($title);
        $title = ucfirst(strtolower($title));
        return $title;
    }

    public function get_group(){
        if($this->objectSubtype == 'product') {
            return 'woocommerce';
        } else {
            return $this->objectSubtype;
        }
    }

    public function get_categories()
    {
        $categories = [];
        if (in_array($this->fieldType, ["text", "textarea", "wysiwyg", "select", "checkbox", "radio", "date", "tax"])) {
            $categories = ["text", "post_meta"];
        } else if(in_array($this->fieldType, ["number"])) {
            $categories = ["number", "post_meta"];
        } else if(in_array($this->fieldType, ["image", "images"])) {
            $categories = ["image", "gallery"];
        } else if(in_array($this->fieldType, ["pdf", "pdfs"])){
            $categories = ["media"];
        }

        return $categories;
    }
    
    public function get_value(array $options = [])
    {
        global $post;
        if(!isset($post) || get_class($post) != 'WP_Post'  || empty($post->ID)){
            return "";
        }

        $value = "";
        if($this->objectType == 'post') {
            if(preg_match('/computed__/', $this->propertyName) != false) {
                $propertyinfo = $this->propertyName;
                $propertyinfo = str_replace('computed__', '', $propertyinfo);
                $propertyinfo = explode('__', $propertyinfo);
    
                $repository = $propertyinfo[0];
                $method = $propertyinfo[1];
    
                if($this->objectSubtype == 'product') {
                    if($post->post_type == 'product') {
                        $product = wc_get_product($GLOBALS['post']);
                        if($product instanceof WC_Product) {
                            $class = TW_Factory::getInstance()->getClass($repository);
                            $value = call_user_func_array([$class, $method], [$product]);
                            $value = $this->format_value($value);
                        }
                    } else if(isset($GLOBALS['product']) && $GLOBALS['product'] !== false){
                        $class = TW_Factory::getInstance()->getClass($repository);
                        $value = call_user_func_array([$class, $method], [$GLOBALS['product']]);
                        $value = $this->format_value($value);
                    }
                } else {
                    $class = TW_Factory::getInstance()->getClass($repository);
                    $value = call_user_func_array([$class, $method], [$post]);
                    $value = $this->format_value($value);
                }            
            } else {
                if($this->objectSubtype == "product") {
                    if($post->post_type == 'product') {
                        $product = wc_get_product($GLOBALS['post']);
                        if($product instanceof WC_Product) {
                            if($this->fieldType == 'tax') {
                                $value = $product->getCustomAttributesOrTaxonomy($this->propertyName, "NAME");
                            } else {
                                $value = $product->getCustomAttributesOrTaxonomy($this->propertyName);
                            }
                            $value = $this->format_value($value);
                        }
                    } else if(isset($GLOBALS['product']) && $GLOBALS['product'] !== false) {
                        $product = $GLOBALS['product'];
                        if($product instanceof WC_Product) {
                            if($this->fieldType == 'tax') {
                                $value = $product->getCustomAttributesOrTaxonomy($this->propertyName, "NAME");
                            } else {
                                $value = $product->getCustomAttributesOrTaxonomy($this->propertyName);
                            }
                            $value = $this->format_value($value);
                        }
                    }
                } else {
                    $postRecords = TW_Factory::getInstance()->getClass(TW_General_Repository::class)->getPostWithCustomRecord(
                        $post->ID
                    );
        
                    if(isset($postRecords->custom_records[$this->propertyName])){
                        $value = $postRecords->custom_records[$this->propertyName];
                        $value = $this->format_value($value);
                    }
                }
            }
        }

        return $value;
    }

    private function format_value($value){
        $formattedValue = $value;

        if($this->fieldType == 'date') {
            if($value instanceof DateTime) {
                $formattedValue = $value->format('Y-m-d');
            } else {
                $formattedValue = "";
            }
        } else if($this->fieldType == 'image' || $this->fieldType == 'images') {
            if(is_array($value) && count($value) > 0) {
                $result = $value[0];
                $formattedValue = [
                    'id' => $result['ID'],
                    'url' => $result['guid']
                ];
            }
        } else if($this->fieldType == 'tax') {
            if(is_array($value) && count($value) > 0) {
                $formattedValue = implode(", ", $value);
            }
        }

        return $formattedValue;
    }
}

function tw_register_custom_elementor_tags(Manager $tagManager)
{
    if(isset($GLOBALS['tw_metas']) && !empty($GLOBALS['tw_metas'])) {
        foreach($GLOBALS['tw_metas'] as $type_key => $meta_definition) {
            list($object_type, $object_subtype) = _tw_parse_meta_key_definition_type($type_key);
            foreach($meta_definition as $meta_name => $meta_info) {
                $className = "TWTAG___" . $object_type . '___' . $object_subtype . '___' . $meta_name . '___' . $meta_info['metabox_field']['field_type'];
                
                eval("class " . $className . "  extends TW_Custom_Elementor_Tag {}");
                $tagManager->register(new $className());
            }
        }
    }

    if(isset($GLOBALS['tw_taxonomies']) && !empty($GLOBALS['tw_taxonomies'])) {
        foreach($GLOBALS['tw_taxonomies'] as $type_key => $tax_definition) {
            list($object_type, $object_subtype) = _tw_parse_meta_key_definition_type($type_key);
            foreach($tax_definition as $tax_name => $tax_info) {
                $className = "TWTAG___" . $object_type . '___' . $object_subtype . '___' . $tax_name . '___tax';
                
                eval("class " . $className . "  extends TW_Custom_Elementor_Tag {}");
                $tagManager->register(new $className());
            }
        }
    }

    if(isset($GLOBALS['tw_computed_properties']) && !empty($GLOBALS['tw_computed_properties'])) {
        foreach($GLOBALS['tw_computed_properties'] as $type_key => $computed_definition) {
            list($object_type, $object_subtype) = _tw_parse_meta_key_definition_type($type_key);
            foreach($computed_definition as $def_name => $def_info) {
                $className = "TWTAG___" . $object_type . '___' . $object_subtype . '___computed__' . $def_info['repository'] . '__' . $def_info['method'] . '___text';
                
                eval("class " . $className . "  extends TW_Custom_Elementor_Tag {}");
                $tagManager->register(new $className());
            }
        }
    }

    if(isset($GLOBALS['tw_product_default_attributes']) && !empty($GLOBALS['tw_product_default_attributes'])) {
        foreach($GLOBALS['tw_product_default_attributes'] as $attr_key => $attr_definition) {
            $className = "TWTAG___post___product" . '___' . $attr_key . '___text';

            eval("class " . $className . "  extends TW_Custom_Elementor_Tag {}");
            $tagManager->register(new $className());
        }
    }

    if(isset($GLOBALS['tw_product_default_taxonomy']) && !empty($GLOBALS['tw_product_default_taxonomy'])) {
        foreach($GLOBALS['tw_product_default_taxonomy'] as $attr_key) {
            $className = "TWTAG___post___product" . '___' . $attr_key . '___tax';

            eval("class " . $className . "  extends TW_Custom_Elementor_Tag {}");
            $tagManager->register(new $className());
        }
    }
}

function tw_register_custom_elementor_tags_group(Manager $tagManager)
{
    if(isset($GLOBALS['tw_metas']) && !empty($GLOBALS['tw_metas'])) {
        foreach($GLOBALS['tw_metas'] as $type_key => $meta_definition) {
            list($object_type, $object_subtype) = _tw_parse_meta_key_definition_type($type_key);
            if($object_type == "post") {
                $tagManager->register_group(
                    $object_subtype,
                    [
                        'title' => esc_html__(ucfirst(strtolower($object_subtype)), 'tw-core')
                    ]
                );
            }
        }
    }

    if(isset($GLOBALS['tw_taxonomies']) && !empty($GLOBALS['tw_taxonomies'])) {
        foreach($GLOBALS['tw_taxonomies'] as $type_key => $tax_definition) {
            list($object_type, $object_subtype) = _tw_parse_meta_key_definition_type($type_key);
            if($object_type == "post") {
                $tagManager->register_group(
                    $object_subtype,
                    [
                        'title' => esc_html__(ucfirst(strtolower($object_subtype)), 'tw-core')
                    ]
                );
            }
        }
    }
}