<?php

class TwShippingLabelCommand {
    public function generateLabel()
    {
        global $wpdb;
        $shippingRepository = TW_Factory::getInstance()->getClass(TW_Shipping_Repository::class);
        
        $shippingsToReGenerate = $shippingRepository->getShippingToRegenerate(3);
        foreach($shippingsToReGenerate as $item) {
            $articles = $item['shipping_details'];
            $useInsurance = $item['insurance'] == 1 ? 'yes' : 'no';

            $shipmentItem = $item;
            unset($shipmentItem['shipping_details']);
            $shipment = new TW_Shipping($shipmentItem);

            $shipmentDetails = [];
            foreach($articles as $detail){
                $shipmentDetails[] = new TW_Shipping_Detail($detail);
            }

            $shippingHander = TW_Shipping_Manager::getInstance()->getHandler($shipment, $shipmentDetails);
            if($shippingHander !== null) {
                list($handlerResult, $handlerMsg) = $shippingHander->generateShipmentTrackingFromShipmentInfo($shipment, $shipmentDetails, $useInsurance);
            }
        }

        $status = "wc-completed";
        $maxNbrDays = 3;

        $orderIdsWithoutShipment = $shippingRepository->getOrdersIdWithoutShipping($status, $maxNbrDays);
        foreach($orderIdsWithoutShipment as $orderId) {
            list($shipment, $shipmentDetails) = TW_Shipping_Manager::getInstance()->createShipmentInfoFromEmptyShipment($orderId);

            if($shipment !== null && count($shipmentDetails) > 0) {
                $useInsurance = $shipment->insurance == 1 ? 'yes' : 'no';

                $shippingHander = TW_Shipping_Manager::getInstance()->getHandler($shipment, $shipmentDetails);
                if($shippingHander !== null) {
                    list($handlerResult, $handlerMsg) = $shippingHander->generateShipmentTrackingFromShipmentInfo($shipment, $shipmentDetails, $useInsurance);
                }
            }
        }

        WP_CLI::success("OK");
    }
}

add_action('cli_init', function(){
    if(tw_is_plugin_active("woocommerce/woocommerce.php")){
        WP_CLI::add_command('tw_shipping_label_command', 'TwShippingLabelCommand');
    }
});