<?php

/**
 * ATTENTION METTRE UN AVERTISSEMENT QUAND ON ESSAIE D UTILISER UNE TAXONOMY QUI N'A PAS ETEE CRER AVANT
 * METTRE UNE SORTE D ERREUR FATALE
 * 
 * ATTENTION LES TERMES NE SE RAJOUTER PAS AUTOMATIQUEMENT DANS LES TAXONOMIES
 * PREVOIR CE DÉVELOPPEMENT ET METTRE UNE ERREUR SI UNE TAXONOMIE SANS AJOUTER AUTOMATIQUE DE TERMES
 * A ETE IMPORTEE
 */
//when updating the products add param 1 after the file name
//to get the reason why a peculiar image cannot be imported put a breakpoint in TW_Product_Csv_Importer::set_image_data (if needed)
class TwImportCommand {

    private $importer = null;

    public function import($args, $assoc_args){
        global $wpdb;
        $update_existing = false;

        if(count($args) < 1) {
            throw new \Exception("Missing required argument file");
        }
        $file =  ABSPATH . trim($args[0]);
        
        if(count($args) >= 2) {
            $update_existing = $args[1] == 1 ? true : false;
        }

        //include ABSPATH . 'wp-content/plugins/woocommerce/includes/admin/importers/mappings/default.php';

        $importer_class = apply_filters( 'woocommerce_product_csv_importer_class', 'WC_Product_CSV_Importer' );
		$importer_args  = apply_filters( 'woocommerce_product_csv_importer_args', [
            'parse' => true,
            'update_existing' => $update_existing,
            'mapping' => []
        ], $importer_class );

        add_filter('tw_product_importer_before_read_file', function($mapping){
            $mapping = wc_importer_default_english_mappings([]);
            $mapping = tw_product_import_support_custom_mapping($mapping);
            return $mapping;
        }, PHP_INT_MAX);

        //need admin privilege to import categories
        wp_set_current_user(1);


        $this->importer = new $importer_class( $file, $importer_args );

        try {
            $wpdb->query('START TRANSACTION');

            $results = $this->importer->import();

            if(isset($results['imported_with_errors']) && count($results['imported_with_errors']) > 0){
                foreach($results['imported_with_errors'] as $failed_result) {
                    $error_codes = $failed_result->get_error_codes();
                    if(in_array('tw_core_image_import_error', $error_codes)){
                        $error_data = $failed_result->get_error_data('tw_core_image_import_error');

                        $msg = "";
                        if(isset($error_data['row'])){
                            $msg = "IMAGE IMPORT FAILED ROW: " . $error_data['row'];
                        }
                        WP_CLI::error($msg, false);
                    }
                }
            }

            if(isset($results['failed']) && count($results['failed']) > 0) {
                foreach($results['failed'] as $failed_result) {
                    $error_codes = $failed_result->get_error_codes();
                    if(in_array('tw_core_image_import_error', $error_codes)){
                        $error_data = $failed_result->get_error_data('tw_core_image_import_error');

                        $msg = "";
                        if(isset($error_data['sku'])){
                            $msg = "IMAGE IMPORT FAILED SKU: " . $error_data['sku'];
                        } else {
                            $msg = "IMAGE IMPORT FAILED IMAGE: " . $error_data['image'];
                        }
                        WP_CLI::error($msg, false);
                    } else {
                        $messages = $failed_result->get_error_messages();
                        $msg = "UNHANDLED IMPORT ERROR : " . implode(', ', $messages);
                        WP_CLI::error($msg, false);
                    }
                }
            }

            $wpdb->query('COMMIT');
            WP_CLI::success('Import successful');
        } catch(\Exception $ex) {
            $wpdb->query('ROLLBACK');
            WP_CLI::error($ex->getMessage());
        }
    }
}
add_action('cli_init', function(){
    \WP_CLI::add_command('tw_core_import_command', 'TwImportCommand');
});