<?php

defined( 'ABSPATH' ) || exit;

class TW_WP_Query {
    private $pdo = null;
    private $args = [];
    private $joinedAlias = [
        'meta_query' => [],
        'tax_query' => []
    ];

    private $termsList = [];
    private $joinClause = [];
    private $whereClause = [];
    
    public $posts_per_page = null;
    public $found_posts = 0;
    public $max_num_pages = 0;
    public $posts = [];

    public function __construct($args, $pdo = null)
    {
        if($pdo !== null) {
            $this->pdo = $pdo;
        } else {
            $this->pdo = tw_pdo_connection();
        }

        $this->args = $args;
        $this->found_posts = $this->_query(true);

        /*
        if(isset($this->args['offset']) && (int)$this->args['offset'] > $this->found_posts) {
            $this->args['offset'] = null;
        }
        */

        if(isset($this->args['posts_per_page'])) {
            $this->posts_per_page = $this->args['posts_per_page'];
            $max_num_pages = $this->found_posts / $this->posts_per_page;
            if(tw_get_decimal_part($this->found_posts / $this->posts_per_page) > 0) {
                $max_num_pages = (int)$max_num_pages + 1;
            }

            if($max_num_pages < 1) {
                $max_num_pages = 1;
            }
            $this->max_num_pages = $max_num_pages;
        } else {
            $this->max_num_pages = 1;
        }

        $posts = $this->_query();
        foreach($posts as $post) {
            $this->posts[] = new WP_Post($post);
        }
        return $this;
    }

    private function _query($count = false)
    {
        $select[] = 'wp.*';
        if(isset($this->args['select'])){
            if(!is_array($this->args['select'])){
                $select[] = $this->args['select'];
            } else {
                foreach($this->args['select'] as $item) {
                    $select[] = $item;
                }
            }
        }

        $selectStmt = implode(", ", $select);
        if($count == false) {
            $stmt = "SELECT " . $selectStmt . " FROM wp_posts wp";
        } else {
            $stmt = "SELECT COUNT(src.ID) FROM ( SELECT " . $selectStmt . " FROM wp_posts wp";
        }

        $this->_joinQuery();
        foreach($this->joinClause as $item) {
            $stmt .= "\n";
            $stmt .=  " " . $item;
        }

        $this->_processWhere();
        $stmt .= "\n";
        $stmt .= " WHERE 1 = 1";
        foreach($this->whereClause as $item) {
            $stmt .= "\n";
            $stmt .= " " . $item;
        }

        if(isset($this->args['groupby'])){
            $stmt .= "\n";
            $stmt .= " " . "GROUP BY";
            if(!is_array($this->args['groupby'])){
                $stmt .= " " . $this->args['groupby'];
            } else {
                for($i=0;$i<count($this->args['groupby']);$i++){
                    if($i < 1) {
                        $stmt .= " " . $this->args['groupby'][$i];
                    } else {
                        $stmt .= "," . $this->args['groupby'][$i];
                    }
                }
            }
        }

        if(isset($this->args['orderby']) && !empty($this->args['orderby'])){
            $stmt .= "\n";
            $stmt .= " " . "ORDER BY";
            $orderKeys = array_keys($this->args['orderby']);
            for($i=0;$i<count($orderKeys);$i++) {
                $orderKey = $orderKeys[$i];
                $orderValue = $this->args['orderby'][$orderKey];

                if($i < 1) {
                    $stmt .= " " . $orderKey . " " . $orderValue;
                } else {
                    $stmt .= "," . $orderKey . " " . $orderValue;
                }
            }
        }

        $limit = null;
        $offset = null;
        if(isset($this->args['posts_per_page'])){
            $limit = $this->args['posts_per_page'];
        }
        if(isset($this->args['offset'])){
            $offset = $this->args['offset'];
        }

        if($count == false) {
            if(isset($limit)){
                $stmt .= "\n";
                $stmt .= " LIMIT " . $limit;
                if(isset($offset)) {
                    $stmt .= " OFFSET " . $offset;
                } 
            }
        }

        if($count == true) {
            $stmt .= ") as src";
            $pdoStmt = $this->pdo->query($stmt);
            return (int)$pdoStmt->fetchColumn(0);
        } else {
            $pdoStmt = $this->pdo->query($stmt);
            return $pdoStmt->fetchAll(PDO::FETCH_OBJ);
        }
    }

    private function _joinQuery()
    {
        $this->joinedAlias = [
            'meta_query' => [],
            'tax_query' => []
        ];
        $this->joinClause = [];

        if(isset($this->args['join']) && !empty($this->args['join'])){
            for($i=0;$i<count($this->args['join']);$i++){
                $joinDetail = $this->args['join'][$i];

                $alias = isset($joinDetail['alias']) ? $joinDetail['alias'] : 'jo' . $i;
                $type = isset($joinDetail['type']) ? $joinDetail['type'] : 'LEFT';
                $table = $joinDetail['table'];
                $on = $joinDetail['on'];

                $this->joinClause[$alias] = $type . " JOIN " . $table . " " . $alias . " ON (" . $on . ")";
            }
        }

        if(isset($this->args['meta_query'])){
            for($i=0;$i<count($this->args['meta_query']);$i++) {
                $currentMetaQuery = $this->args['meta_query'][$i];
                $alias = "mq_" . $i;
                if(isset($currentMetaQuery['alias'])){
                    $alias = "mq_" . $currentMetaQuery['alias'];
                }

                $this->joinedAlias['meta_query'][$i] = $alias;
                if(!isset($this->joinClause[$alias])){
                    $this->joinClause[$alias] = "LEFT JOIN wp_postmeta " . $alias . " ON (" . $alias . ".post_id = wp.ID AND " . $alias . ".meta_key = '" . $currentMetaQuery['field'] . "')";
                }
            }
        }

        if(isset($this->args['tax_query'])){
            for($i=0;$i<count($this->args['tax_query']);$i++) {
                $currentTaxQuery = $this->args['tax_query'][$i];
                $alias = "tq_" . $i;
                if(isset($currentTaxQuery['alias'])){
                    $alias = "tq_" . $currentTaxQuery['alias'];
                }
    
                $this->termsList[$currentTaxQuery['taxonomy']] = get_terms($currentTaxQuery['taxonomy']);
                $currentTermIds = [];
                foreach($this->termsList[$currentTaxQuery['taxonomy']] as $term) {
                    $currentTermIds[] = $term->term_taxonomy_id;
                }

                if(count($currentTermIds) > 0) {
                    $this->joinedAlias['tax_query'][$i] = $alias;
                    if(!isset($this->joinClause[$alias])){
                        $this->joinClause[] = "LEFT JOIN wp_term_relationships " . $alias . " ON (" . $alias . ".object_id = wp.ID AND " . $alias . ".term_taxonomy_id IN (" . tw_explode_ids($currentTermIds) . "))";
                        $this->joinClause[] = "LEFT JOIN wp_term_taxonomy " . $alias . "_tax ON (" . $alias . "_tax.term_taxonomy_id = " . $alias . ".term_taxonomy_id)";
                        $this->joinClause[] = "LEFT JOIN wp_terms " . $alias . "_term ON (" . $alias . "_term.term_id = " . $alias . "_tax.term_id)";
                    }
                }
            }
        }
    }

    private function _processWhere()
    {
        $this->whereClause = [];

        if(isset($this->args["post_type"])){
            $this->whereClause[] = "AND (" . "wp.post_type = " . $this->pdo->quote($this->args['post_type']) . ")";
        }

        if(isset($this->args['s'])){
            $this->whereClause[] = "AND (" . "wp.post_title LIKE " . $this->pdo->quote('%' . $this->args['s'] . '%') . ")";
        }

        if(isset($this->args['post_status'])){
            $this->whereClause[] = "AND (" . "wp.post_status = " . $this->pdo->quote($this->args['post_status']) . ")";
        } else {
            $this->whereClause[] = "AND (" . "wp.post_status = " . $this->pdo->quote('publish') . ")";
        }

        foreach($this->joinedAlias['tax_query'] as $index => $detail) {
            $taxArg = $this->args['tax_query'][$index];
            $correspondingAlias = $this->joinedAlias['tax_query'][$index];

            $relation = "AND";
            if(isset($taxArg['relation'])){
                $relation = $taxArg['relation'];
            }

            $operator = "IN";
            if(isset($taxArg['operator'])){
                $operator = $taxArg['operator'];
            }

            $field = "slug";
            if(isset($taxArg['field'])){
                $field = $taxArg['field'];
            }

            if(!in_array($operator, array("IN", "NOT IN", "NOP"))){
                throw new \Exception("TW_WP_QUERY UNSUPPORTED EXCEPTION");
            }
            
            if($operator != "NOP") {
                $searchedTerms = [];
                if(is_array($taxArg['terms'])){
                    $searchedTerms = $taxArg['terms'];
                } else {
                    $searchedTerms[] = $taxArg['terms'];
                }

                if(isset($taxArg['type']) && $taxArg['type'] == 'numeric') {
                    $this->whereClause[] = $relation . " (" . $correspondingAlias . "_term" .  "." . $field . " " . $operator . "(" . tw_explode_ids($searchedTerms) . "))";
                } else {
                    $this->whereClause[] = $relation . " (" .  $correspondingAlias . "_term" .  "." . $field . " " . $operator . "(" . tw_explode_strings($searchedTerms, true, $this->pdo) . "))";
                }
            }
        }

        foreach($this->joinedAlias['meta_query'] as $index => $detail) {
            $metaArg = $this->args['meta_query'][$index];
            $correspondingAlias = $this->joinedAlias['meta_query'][$index];

            $relation = "AND";
            if(isset($metaArg['relation'])){
                $relation = $metaArg['relation'];
            }
            $operator = "=";
            if(isset($metaArg['operator'])){
                $operator = $metaArg['operator'];
            }

            if($operator != "NOP") {
                $value = null;

                if(isset($metaArg['value'])){
                    $value = $metaArg['value'];
                }

                if(!is_array($value)){
                    if(isset($metaArg['operator'])){
                        $operator = $metaArg['operator'];
                    }

                    if($operator == 'LIKE') {
                        $value = '%' . $value . '%';
                    }

                    if($operator == "NOT NULL") {
                        $this->whereClause[] = $relation . " (" . $correspondingAlias . ".meta_value" . " IS NOT NULL)";
                    } else if(isset($metaArg['type']) && $metaArg['type'] == 'numeric') {
                        $this->whereClause[] = $relation . " (" . $correspondingAlias . ".meta_value" . " " . $operator  . " " . $value . ")";
                    } else {
                        $this->whereClause[] = $relation . " (" . $correspondingAlias . ".meta_value"  . " " . $operator . " " . $this->pdo->quote($value) . ")";
                    }
                } else {
                    $operator = "IN";
                    if(isset($metaArg['operator'])){
                        $operator = $metaArg['operator'];
                    }

                    if(!in_array($operator, array("IN", "NOT IN", "NOP"))){
                        throw new \Exception("TW_WP_QUERY UNSUPPORTED EXCEPTION");
                    }

                    if(isset($metaArg['type']) && $metaArg['type'] == 'numeric') {
                        $this->whereClause[] = $relation . " (" . $correspondingAlias .  ".meta_value" . " " . $operator  . " (" . tw_explode_ids($value) . "))";
                    } else {
                        $this->whereClause[] = $relation . " (" . $correspondingAlias .  ".meta_value"  . " " . $operator . " (" . tw_explode_strings($value, true, $this->pdo) . "))";
                    }
                }
            }
        }
    }

    public function hydrateWpQuery(WP_Query $query)
    {
        if(isset($this->posts_per_page)){
            $query->posts_per_page = $this->posts_per_page;
        }

        $query->max_num_pages = $this->max_num_pages;
        $query->found_posts = $this->found_posts;
        $query->posts = $this->posts;
        $query->post_count = count($this->posts);
    }
}