<?php

class TW_Supercache_Rest_Preload extends WP_REST_Controller {

    const MAX_NUMBER_SIMULTANOUS_CALLS = 4;
    const TIMESTAMP_AUTHORIZED_DELAY_IN_MINUTES = 15;

    public function __construct()
    {
        $this->tw_logger = $GLOBALS['tw_logger'];
    }

    /**
     * vérifier dans quel mesure wp super cache clean cette request 
     */
    private function _preload($urls) {
        $this->tw_logger->debug('inside preload');
        $this->tw_logger->debug(print_r($urls, true));
        $results = [];

        // Vérifie si cURL multi est disponible
        if (function_exists('curl_multi_init')) {
            $this->tw_logger->debug('using multi curl');
            $multiHandle = curl_multi_init();
            $curlHandles = [];

            // Prépare chaque requête
            foreach ($urls as $i => $url) {
                $ch = curl_init($url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_TIMEOUT, 10);
                $curlHandles[$i] = $ch;
                curl_multi_add_handle($multiHandle, $ch);
            }

            // Exécute toutes les requêtes en parallèle
            $running = null;
            do {
                curl_multi_exec($multiHandle, $running);
                curl_multi_select($multiHandle);
            } while ($running > 0);

            // Récupère les résultats
            foreach ($curlHandles as $i => $ch) {
                $this->tw_logger->debug('using single curl');
                $results[$i] = curl_multi_getcontent($ch);
                curl_multi_remove_handle($multiHandle, $ch);
                curl_close($ch);
            }
            curl_multi_close($multiHandle);
        } else {
            // Fallback : requêtes simples une par une
            foreach ($urls as $i => $url) {
                $ch = curl_init($url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_TIMEOUT, 10);
                $results[$i] = curl_exec($ch);
                curl_close($ch);
            }
        }

        return $results;
    }

    public function callback(WP_REST_Request $request) {
        $currentTimestamp = strtotime('now');
		$params = $request->get_json_params();

        $urls = $params['url'];
        $this->tw_logger->debug("inside callback");
        $this->tw_logger->debug(print_r($params, true));
        $this->tw_logger->debug(print_r($urls, true));
        if(count($urls) > self::MAX_NUMBER_SIMULTANOUS_CALLS) {
            $urls = array_slice($urls,0,self::MAX_NUMBER_SIMULTANOUS_CALLS);
        }

        $this->_preload($urls);
        $this->tw_logger->debug(print_r('cache url', true));
        $this->tw_logger->debug(print_r($urls, true));
        foreach($urls as $url) {
            TW_Factory::getInstance()->getClass(TW_Cached_Page_Repository::class)->markAsLoaded($currentTimestamp, $url);
        }
		return rest_ensure_response(array( 'Status' => 'OK'));
	}

    public function get_item_permissions_check($request)
    {
        $now = new DateTime();
        $currentTimestamp = (int)$now->format('U');
        $maxDelay = self::TIMESTAMP_AUTHORIZED_DELAY_IN_MINUTES;
        $maxDelay = PHP_INT_MAX;

        $params = $request->get_query_params();
        $timestamp = isset($params['timestamp']) ? (int)$params['timestamp'] : null;
        $hash = isset($params['hash']) ? $params['hash'] : null;

        if($timestamp !== null
        && (($currentTimestamp - $params['timestamp']) / 60) < $maxDelay
        && $hash !== null
        && $hash == wp_hash('tw_preload_cache_' . $timestamp, 'nonce')) {
            return true;
        }
        return false;
    }
}