<?php

defined( 'ABSPATH' ) || exit;

trait TW_Stock_Management_trait {
    public $stock_management_data = null;
    public $backorder_limit = null;

    public function get_stock_management_mode(){
        return isset($this->stock_management_data['stock_management_mode']) ? $this->stock_management_data['stock_management_mode'] :  get_post_meta($this->get_id(), 'stock_management_mode', true);
    }

    public function get_stock_management_url(){
        return isset($this->stock_management_data['stock_management_url']) ? $this->stock_management_data['stock_management_url'] :  get_post_meta($this->get_id(), 'stock_management_url', true);
    }

    public function set_stock_management_data($stock_management_data){
        $this->stock_management_data = $stock_management_data;
        if($this->stock_management_data['stock_management_mode'] == "dedicated_stock_managed_by_woocommerce") {
            $this->set_manage_stock(1);
        } else {
            $this->set_manage_stock(0);
        }
    }

    public function save_stock_management_data(){
        if($this->stock_management_data !== null) {
            update_post_meta($this->get_id(), 'stock_management_mode', $this->stock_management_data['stock_management_mode']);
            update_post_meta($this->get_id(), 'stock_management_url', $this->stock_management_data['stock_management_url']);
        }
    }

    public function get_backorder_limit(){
        $limit = $this->backorder_limit === null ? get_post_meta($this->get_id(), 'backorder_limit', true) : $this->backorder_limit;

        if($limit === false || empty($limit)) {
            return null;
        }
        return (int)$limit;
    }

    public function set_backorder_limit($limit)
    {
        $limit = empty($limit) ? '': $limit;
        $this->backorder_limit = $limit;
    }

    public function save_backorder_limit(){
        if($this->backorder_limit !== null) {
            update_post_meta($this->get_id(), 'backorder_limit', $this->backorder_limit);
        }
    }

    public function has_enough_stock($quantity)
    {
        $has_enough_stock = parent::has_enough_stock($quantity);
        return apply_filters('tw_has_enough_stock', $has_enough_stock, $quantity, $this);
    }
}