<?php

require_once ABSPATH . 'wp-admin/includes/template.php';
require_once ABSPATH . 'wp-admin/includes/class-wp-screen.php';
require_once ABSPATH  . 'wp-admin/includes/class-wp-posts-list-table.php';
require_once ABSPATH  . 'wp-content/plugins/woocommerce/includes/admin/list-tables/class-wc-admin-list-table-products.php';
require_once ABSPATH  . 'wp-content/plugins/woocommerce/includes/admin/class-wc-admin-assets.php';


/**
 *  TODO load les custom meta via tw_product_repository
 */
class TW_Stock_List_Table extends WP_Posts_List_Table {

	private $products_stock_management = [];
	private $admin_table_renderer = null;

	public function __construct($args = [])
	{
		parent::__construct($args);

		add_filter('woocommerce_screen_ids', function($screen_ids){
			$screen_ids[] = 'toplevel_page_tw-core-stock-page';
			return $screen_ids;
		});
		wp_enqueue_style( 'woocommerce_admin_styles');

		$this->admin_table_renderer = new WC_Admin_List_Table_Products();
	}

	protected function get_bulk_actions() {
		return [];
	}

	protected function extra_tablenav($which)
	{
		$orders = [];
		$orders['order_by_most_sold_items'] = __('Trier par articles les plus vendus');
		$orders['order_by_stock'] = __('Trier par les articles avec le plus faible stock');

		$selected = isset($_GET['displayOrder']) ? $_GET['displayOrder'] : 'order_by_most_sold_items';

		echo '<select name="display_order">';
		foreach($orders as $orderKey => $orderLabel) {
			if($orderKey == $selected) {
				echo '<option selected="selected" value="' . $orderKey . '">' . $orderLabel . '</option>';
			} else {
				echo '<option value="' . $orderKey . '">' . $orderLabel . '</option>';
			}
		}
		echo '</select>';
	}

	private function get_custom_columns()
	{
		$custom_columns = [
			'cb' => '<input type="checkbox" />',
			'thumb' => '<span class="wc-image tips" data-tip="' . esc_attr__( 'Image', 'woocommerce' ) . '">' . __( 'Image', 'woocommerce' ) . '</span>',
			'name' => __( 'Name', 'woocommerce' ),
		];

		if ( wc_product_sku_enabled() ) {
			$custom_columns['sku'] = __( 'SKU', 'woocommerce' );
		}

		$custom_columns['price'] = __( 'Price', 'woocommerce' );
		if (false) {
			$show_columns['cogs_value'] = __( 'Cost', 'woocommerce' );
		}

		$custom_columns['product_cat'] = __( 'Categories', 'woocommerce');
		$custom_columns['product_tag'] = __( 'Tags', 'woocommerce' );
		$custom_columns['featured']    = '<span class="wc-featured parent-tips" data-tip="' . esc_attr__( 'Featured', 'woocommerce' ) . '">' . __( 'Featured', 'woocommerce' ) . '</span>';
		$custom_columns['date']        = __( 'Date', 'woocommerce' );
		$custom_columns['revenue']	   = __('Revenue', 'tw-core');
		
		if ( 'yes' === get_option( 'woocommerce_manage_stock' ) ) {
			$custom_columns['is_in_stock'] = __('Stock status', 'woocommerce' );
		}
		
		$custom_columns['stock'] 	   = __('Stock quantity', 'tw-core');
		return $custom_columns;
	}

	protected function get_sortable_columns()
	{
		return [];
	}

	public function get_columns()
	{
		$parent_columns = parent::get_columns();
		unset(
			$parent_columns['title'], 
			$parent_columns['content'], 
			$parent_columns['date'],
			$parent_columns['is_in_stock']
		);

		$custom_columns = $this->get_custom_columns();
		return array_merge($parent_columns, $custom_columns);
	}

	protected function get_table_classes() {
		$classes = parent::get_table_classes();
		$classes[] = strtolower(get_class($this));

		return $classes;
	}

	/**
	 * @global string   $mode             List table view mode.
	 * @global array    $avail_post_stati
	 * @global WP_Query $wp_query         WordPress Query object.
	 * @global int      $per_page
	 */
	public function prepare_items() {
		global $mode, $avail_post_stati, $wp_the_query, $per_page;

		//$this->prepare_column_headers();

		$post_type = $this->screen->post_type;
		$per_page  = $this->get_items_per_page( 'edit_' . $post_type . '_per_page' );
		$per_page = apply_filters( 'edit_posts_per_page', $per_page, $post_type );

		$parsedUrl = tw_parse_url($_SERVER['REQUEST_URI']);
		$paged = isset($parsedUrl['params']['paged']) ? (int)$parsedUrl['params']['paged'] : 0;
		$offset = $paged * $per_page;

		$query_args = [
			"post_type" => "product",
			"select" => [
				"SUM(wwpal.product_gross_revenue) as product_gross_revenue",
				"SUM(wwpal.product_qty) as product_quantity",
				"price.meta_value as price",
				"stock.meta_value as stock"
			],
			"join" => [
				[
					"type" => "LEFT",
					"table" => "wp_wc_order_product_lookup",
					"alias" => "wwpal",
					"on" => "wwpal.product_id = wp.ID"
				],
				[
					"type" => "LEFT",
					"table" => "wp_postmeta",
					"alias" => "price",
					"on" => "price.post_id = wp.ID and price.meta_key = '_price'"
				],
				[
					"type" => "LEFT",
					"table" => "wp_postmeta",
					"alias" => "stock",
					"on" => "stock.post_id = wp.ID and price.meta_key = '_stock'"
				],

			],
			"groupby" => [
				"wp.ID"
			],
			"orderby" => [
				"SUM(wwpal.product_gross_revenue)" => "DESC"
			]
		];

		if(isset($_GET['displayOrder']) && $_GET['displayOrder'] == 'order_by_stock'){
			$query_args['orderby'] = ["price.meta_value" => "DESC"];
		}

		$customQuery = new TW_WP_Query($query_args);
		$wp_the_query->query($query_args);
		$customQuery->hydrateWpQuery($wp_the_query);

		$generalRepository = TW_Factory::getInstance()->getClass(TW_General_Repository::class);
		$post_ids = [];
		foreach($customQuery->posts as $item) {
			$post_ids[] = $item->ID;
		}
		$this->products_stock_management = $generalRepository->getMetaValuesIndexedByPost('stock_management_mode', $post_ids);

		if ( ! empty( $_REQUEST['mode'] ) ) {
			$mode = 'excerpt' === $_REQUEST['mode'] ? 'excerpt' : 'list';
			set_user_setting( 'posts_list_mode', $mode );
		} else {
			$mode = get_user_setting( 'posts_list_mode', 'list' );
		}

		$this->set_hierarchical_display(false);
		$total_items = $wp_the_query->found_posts;
		//$this->is_trash = isset( $_REQUEST['post_status'] ) && 'trash' === $_REQUEST['post_status'];

		$this->set_pagination_args(
			array(
				'total_items' => $total_items,
				'per_page'    => $per_page,
			)
		);
	}

	public function column_is_in_stock($item) {
		global $the_product;

		$stock_html = '';
		if ($the_product->is_on_backorder() ) {
			$stock_html = '<mark class="onbackorder">' . __( 'On backorder', 'woocommerce' ) . '</mark>';
		} elseif ( $the_product->is_in_stock() ) {
			$stock_html = '<mark class="instock">' . __( 'In stock', 'woocommerce' ) . '</mark>';
		} else {
			$stock_html = '<mark class="outofstock">' . __( 'Out of stock', 'woocommerce' ) . '</mark>';
		}

		$stock_html = wp_kses_post( apply_filters( 'woocommerce_admin_stock_html', $stock_html, $the_product ));
		return $stock_html;
	}

	public function column_revenue($item){
		return '<span style="font-weight:bold;">' . round($item->product_gross_revenue, 2) . '</span>';
	}

	public function column_stock($item){
		global $the_product;
		
		$stock_managed_by_woocommerce = true;
		if(isset($this->products_stock_management[$item->ID]) && $this->products_stock_management[$item->ID] != "dedicated_stock_managed_by_woocommerce") {
			$stock_managed_by_woocommerce = false;
		}

		if($stock_managed_by_woocommerce == true) {
			return '<input type="number" value="' . $the_product->get_stock_quantity() . '" name="stock_quantity_' . $item->ID . '"/>';
		} else {
			return '<input type="number" value="' . $the_product->get_stock_quantity() . '" disabled="disabled" name="stock_quantity_' . $item->ID . '"/>';
		}
	}

	public function single_row($item, $level = 0) {
		//inherit from parent
		$global_post = get_post();

		$post                = get_post( $item );
		$this->current_level = $level;

		$GLOBALS['post'] = $post;
		setup_postdata( $post );

		global $the_product;
		$the_product = wc_get_product($item->ID);
		tw_set_property($this->admin_table_renderer, 'object', $the_product);
		
		$stock_managed_by_woocommerce = true;
		if(isset($this->products_stock_management[$item->ID]) && $this->products_stock_management[$item->ID] != "dedicated_stock_managed_by_woocommerce") {
			$stock_managed_by_woocommerce = false;
		}

		if($stock_managed_by_woocommerce == true) {
			echo '<tr id="post-' . $item->ID . '">';
			$this->single_row_columns($item);
			echo '</tr>';
		} else {
			echo '<tr id="post-' . $item->ID . '" class="disabled">';
			$this->single_row_columns($item);
			echo '</tr>';
		}
		$GLOBALS['post'] = $global_post;
	}

	/*
	public function define_columns($parent_columns)
	{
		unset($parent_columns['title'], $parent_columns['content'], $parent_columns['date']);

		$custom_columns = $this->get_custom_columns();
		return array_merge($parent_columns, $custom_columns);
	}
	*/
}