<?php

defined( 'ABSPATH' ) || exit;

/**
 * TODO gérer la soumission de la metabox
 */
class TW_Shipping_Controller {
    const EXPEDITION_TYPES = ['outward','inward'];

    
    public function __construct()
    {
        require_once __DIR__ . '/tw_order_item_product.php';
    }

    private function _prepare_shipment_data()
    {
        global $theorder;
        $shippingRepository = TW_Factory::getInstance()->getClass(TW_Shipping_Repository::class);

        $order_id = $theorder->get_id();
        $ordered_shipping = null;
        if(!empty($theorder->get_items('shipping'))){
            $ordered_shippings = $theorder->get_items('shipping');
            $ordered_shipping = $ordered_shippings[array_keys($ordered_shippings)[0]];
        }

        $carrier = null;
        $carrierInstanceId = null;
        if($ordered_shipping !== null){
            $carrier = $ordered_shipping->get_method_id();
            $carrierInstanceId = $ordered_shipping->get_instance_id();
        }

        $previousShippings = $shippingRepository->getShippingsByOrderId($order_id, true);

        $ordered_articles = [];
        foreach($theorder->get_items('line_item') as $item) {
            $article = new TW_Order_Item_Product($item);

            $ordered_quantity = (int)$article->get_quantity();
            $allready_shipped_quantity = TW_Factory::getInstance()->getClass(TW_Shipping_Repository::class)->getShippedQuantityForOrderItem(
                $order_id,
                $article->get_id()
            );
            $article->set_shipped_quantity($allready_shipped_quantity);
            $quantity_to_ship = $ordered_quantity - $allready_shipped_quantity;
            $article->set_quantity_to_ship($quantity_to_ship);

            $ordered_articles[$article->get_id()] = $article;
        }

        $shipping_options = [];
        $shipping_methods = $shippingRepository->get_shipping_methods_from_order($order_id);
        foreach($shipping_methods as $method) {
            $shipping_options[$method->get_rate_id()] = $method->get_method_title();
        }

        $expedition_types = [];
        foreach(self::EXPEDITION_TYPES as $type) {
            $expedition_types[$type] = $this->get_expeditiontype_label($type);
        }

        $templatePath = dirname(__DIR__) . '/templates/shipment_metabox.php';

        return [
            'order_id' => $order_id,
            'carrier' => $carrier,
            'carrierInstanceId' => $carrierInstanceId,
            'shipping_options' => $shipping_options,
            'expedition_types' => $expedition_types,
            'ordered_articles' => $ordered_articles,
            'ordered_shippings' => $ordered_shippings,
            'previous_shippings' => $previousShippings
        ];
    }

    public function prepare_metabox()
    {
        $data = $this->_prepare_shipment_data();

        $templatePath = dirname(__DIR__) . '/templates/shipment_metabox.php';

        ob_start();
        load_template($templatePath, false, [
            'order_id' => $data['order_id'],
            'carrier' => $data['carrier'],
            'carrierInstanceId' => $data['carrierInstanceId'],
            'shipping_options' => $data['shipping_options'],
            'expedition_types' => $data['expedition_types'],
            'ordered_articles' => $data['ordered_articles'],
            'ordered_shippings' => $data['ordered_shippings'],
            'previous_shippings' => $data['previous_shippings'],
        ]);
        $tplContent = ob_get_contents();
        ob_end_clean();

        return $tplContent;
    }

    public function prepare_modal()
    {
        $data = $this->_prepare_shipment_data();

        $templatePath = dirname(__DIR__) . '/templates/shipment_modal.php';

        ob_start();
        load_template($templatePath, false, [
            'order_id' => $data['order_id'],
            'carrier' => $data['carrier'],
            'carrierInstanceId' => $data['carrierInstanceId'],
            'shipping_options' => $data['shipping_options'],
            'expedition_types' => $data['expedition_types'],
            'ordered_articles' => $data['ordered_articles'],
            'ordered_shippings' => $data['ordered_shippings'],
            'previous_shippings' => $data['previous_shippings'],
            'nonce' => wp_nonce_field(wp_hash('tw_shipment_form', 'nonce'), 'tw_shipment_form_nonce', true, false)
        ]);
        $tplContent = ob_get_contents();
        ob_end_clean();
        
        return $tplContent;
    }

    /**
     * 
     * DELETE FROM tw_shipping where order_id = 1424

DELETE tw_shipping_detail FROM tw_shipping_detail 
INNER JOIN tw_shipping ON (tw_shipping.expedition_id = tw_shipping_detail.expedition_id)
WHERE tw_shipping.order_id = 1424
     * 
     * 
    * outward label (ne fonctionne pas)
    * génération du pdf
    *
    * statut expédie ou partiellement expédié
    * relance génération en cas d'échech
    * actions batch
    * dans la liste des produitsn vérifier que les produit à expédier ne sont pas virtuel
    * test
    *
    *
    * voir dans TW_SHIPPING_HANDLERS _getItemsListAndInsuranceAmount (celle ci doit être propre au handler)
    * et TW_SHIPPING_HANDLERS createShipmentInfo (celle ci doit être standard)
    * 
    * TW_SHIPPING_HANDLERS 
    * $customParams['totalWeight']
$customParams['nonMachinable']
$customParams['packageLength']
$customParams['packageWidth']
$customParams['packageHeight']
$customParams['useInsurance']
$customParams['insuranceAmount']
$customParams['multiParcelsCurrentNumber']
$customParams['items'][$itemId]['qty']
$customParams['items'][$itemId]['price']
$customParams['items'][$itemId]['weight']
$customParams['description']
$customParams['shippingCosts']
$customParams['multiParcelsAmount']
$customParams['multiParcelsCurrentNumber']
$customParams['blockCode']
    *
    *
    */
    public function save_shipment_data()
    {
        $now = new DateTime();
        $shippingRepository = TW_Factory::getInstance()->getClass(TW_Shipping_Repository::class);
        $data = $_POST;
        $errors = [];

        if(
            $_SERVER['REQUEST_METHOD'] == 'POST' 
            && isset($_POST['tw_shipment_form_nonce'])
            && wp_verify_nonce($_POST['tw_shipment_form_nonce'], wp_hash('tw_shipment_form', 'nonce'))
        ) {
            try {
                $order_id = $data['order_id'];
                $carrier = $data['carrier'];
                if(empty($carrier)){
                    $errors['carrier'] = __("Le transporteur est obligatoire", "tw-core");
                }

                $expedition_type = $data['expedition_type'];
                if(empty($expedition_type)){
                    $errors['expedition_type'] = __("Le type d'expédition est obligatoire", "tw-core");
                }

                $articlesToProcess = [];
                if(isset($data['articles']) && is_array($data['articles'])){
                    foreach($data['articles'] as $item) {
                        $id = $item['item_id'];
                        $quantity = (int)$item['item_quantity'];
                        $itemIsValid = true;

                        $stockQuantity = 0;
                        $article = new TW_Order_Item_Product($id);
                        $allready_shipped_quantity = TW_Factory::getInstance()->getClass(TW_Shipping_Repository::class)->getShippedQuantityForOrderItem(
                            $order_id,
                            $article->get_id()
                        );
                        $article->set_shipped_quantity($allready_shipped_quantity);

                        if($article->get_product() === false) {
                            $errors[$id] = __("Article inconnu" . $id, "tw-core");
                            $itemIsValid = false;
                        }

                        if($article->get_product() !== false 
                            && ($quantity < 1 || !$article->has_enough_quantity_for_shipment($quantity))
                        ) {
                            if($data['expedition_type'] == 'outward' && !$article->has_enough_quantity_for_shipment($quantity) && $quantity > 0){
                                $errors[$id . '_quantity'] = __("Quantité en stock insuffisante pour l'article " . $article->get_product()->get_name(), "tw-core");
                            } else if($data['expedition_type'] == 'inward' && $quantity > $article->get_shipped_quantity()) {
                                $errors[$id . '_quantity'] = __("Quantité supérieur à la quantitée expédiée pour l'article " . $article->get_product()->get_name(), "tw-core");
                            }
                            $itemIsValid = false;
                        }

                        if($itemIsValid == true) {
                            $articlesToProcess[$id] = $article;
                        }
                    }
                }

                if(count($errors) == 0) {
                    $useInsurance = !empty($_POST['ship_with_insurance']) ? $_POST['ship_with_insurance'] : 'no';
                    
                    $articles = [];
                    foreach($data['articles'] as $item) {
                        if(isset($articlesToProcess[$item['item_id']])){
                            $quantity = filter_var($item['item_quantity'], FILTER_VALIDATE_INT);
                            if($quantity > 0) {
                                $articles[] = $item;
                            }
                        }
                    }
                    
                    if(count($articles) > 0) {
                        list($shipment, $shipmentDetails) = TW_Shipping_Manager::getInstance()->createShipmentInfo(
                            $data['order_id'],
                            $data['carrier'],
                            $data['expedition_type'],
                            $articles,
                            $useInsurance
                        );

                        $shippingHander = TW_Shipping_Manager::getInstance()->getHandler($shipment, $shipmentDetails);
                        if($shippingHander !== null) {
                            list($handlerResult, $handlerMsg) = $shippingHander->generateShipmentTrackingFromShipmentInfo($shipment, $shipmentDetails, $useInsurance);
                        }
                        

                        if($handlerResult !== null && $handlerResult === false) {
                            $errors['general'] = $handlerMsg;
                            throw new Exception();
                        }
                    }
                }
            } catch(Exception $ex) {
                if(!isset($errors['general'])) {
                    $errors['general'] = __("Erreur lors de la vérification du formulaire", "tw-core");
                }

                $shippingRepository->delete_shipping_details($shipment);
                $shippingRepository->delete_shipping($shipment);
            }
        } else {
            $errors['general'] = __("Erreur lors de la vérification du formulaire", "tw-core");
        }

        if(count($errors) > 0) {
            wp_send_json([
                'status' => 'error',
                'errors' => $errors
            ], 400);
        } else {
            wp_send_json([
                'status' => 'success',
                'errors' => $errors
            ], 200);
        }
    }

    public function get_expeditiontype_label($expedition_type)
    {
        if($expedition_type == 'outward') {
            return __('Envoi simple', 'tw-core');
        } else if($expedition_type == 'inward') {
            return __('Retour pris en charge par l\'expéditeur', 'tw-core');
        } else if($expedition_type == 'both') {
            return __('Envoi et retour pris en charge par l\'expéditeur', 'tw-core');
        }
    }
}