<?php

defined( 'ABSPATH' ) || exit;

class TW_Shipping {

    public $expedition_id = null;
    public $order_id;
    public $expedition_type;
    public $carrier;
    public $package_length = null;
    public $package_width = null;
    public $package_height = null;
    public $insurance = 0;
    public $label_generated = 0;
    public $label_generation_time = null;
    public $label_number = null;
    public $label_tracking_link = null;
    public $label_print_link = null;

    public function __construct(array $data = []) {
        foreach($data as $key => $value) {
            if (property_exists($this, $key)) {
                if(method_exists($this, 'set_' . $key)){
                    call_user_func_array([$this, 'set_' . $key], $value);
                } else {
                    $this->{$key} = $value;
                }
            }
        }
    }

    public function to_array()
    {
        $reflection = new ReflectionClass($this);
        $properties = $reflection->getProperties();

        foreach ($properties as $property) {
            $values[$property->getName()] = $this->{$property->getName()};
        }
        return $values;
    }

    public function format_number($number, $nbrDecimals = 2)
    {
        $number = floatval($number);
        if(empty($number) || filter_var($number, FILTER_VALIDATE_FLOAT) === false) {
            $number = 0;
        }
        
        return round($number, $nbrDecimals);
    }

    public function get_package_weight($shipmentDetails)
    {
        $totalWeight = 0;
        foreach($shipmentDetails as $detail) {
            $itemWeight = isset($detail->item_weight) ? (int)$detail->item_weight : 0;
            $totalWeight = $totalWeight + ($itemWeight * $detail->item_quantity);
        }

        return $this->format_number($totalWeight);
    }

    public static function tw_pdf_link($expeditionType, $expeditionId, $orderId)
    {
        $nonceName = 'twpdflabel' . $expeditionType . '_' . $expeditionId . '_' . $orderId;
        $nonce = wp_create_nonce($nonceName);

        $pdfLink  = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['SERVER_NAME'] .  '/wp-content/site-override/shippingPdfGenerator.php';
        $pdfLink .= "?expeditionId=" . $expeditionId;
        $pdfLink .= "&expeditionType=" . $expeditionType;
        $pdfLink .= "&nonce=" . $nonce;
        return $pdfLink;
    }
}