<?php 

defined( 'ABSPATH' ) || exit;

class TW_Session {

    private $_session_id = null;
    private $_values = [];

    public function init_db() {
        global $wpdb;
        $wpdb_collate = $wpdb->collate;

        $session_table_sql = "CREATE TABLE tw_session (
            id int(10) NOT NULL AUTO_INCREMENT,
            name varchar(500) NOT NULL,
            value longtext DEFAULT NULL,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (id)
        )
        COLLATE {$wpdb_collate}";
        dbDelta($session_table_sql);
    }

    public function create_session() {
        global $wpdb;
        $this->_session_id = null;

        $expiration_time = time() + (2 * 60 * 60);
        if(!isset($_COOKIE['tw_session'])){
            $this->_session_id  = uniqid(md5("sess_" . strtotime('now')), true);
            setcookie('tw_session', $this->_session_id , $expiration_time);
        } else {
            $this->_session_id  = $_COOKIE['tw_session'];
            setcookie('tw_session', $this->_session_id, $expiration_time);
        }

        $session_value = $wpdb->get_row($wpdb->prepare( "SELECT * FROM tw_session WHERE name = %s", $this->_session_id), ARRAY_A);
        if($session_value !== null && trim($session_value['value']) != '') {
            $this->_values = unserialize($session_value['value']);
        }
    }

    public function get_values() {
        return $this->_values;
    }

    public function set_value($key, $value) {
        global $wpdb;

        $this->_values[$key] = $value;
        $this->_persist_values();
    }

    public function remove_value($key) {
        global $wpdb;

        if(isset($this->_values[$key])){
            unset($this->_values[$key]);
            sort($this->_values);
        }

        $this->_persist_values();
    }

    private function _persist_values() {
        global $wpdb;
        $serializedValues = serialize($this->_values);

        $existing_session = $wpdb->get_row($wpdb->prepare( "SELECT * FROM tw_session WHERE name = %s", $this->_session_id), ARRAY_A);
        if($existing_session !== null) {
            $wpdb->query($wpdb->prepare("UPDATE tw_session SET `value` = %s WHERE `name` = %s", $serializedValues, $this->_session_id));
        } else {
            $wpdb->query($wpdb->prepare("INSERT INTO tw_session(`value`, `name`) VALUES(%s, %s)", $serializedValues, $this->_session_id));
        }
    }
}