<?php

defined( 'ABSPATH' ) || exit;

/**
 * TODO inclure certaines informations dans woocommerce_product_read
 */
class TW_Product_Simple extends WC_Product_Simple {
    use TW_Supplier_Trait;
    use TW_Stock_Management_trait;
    use TW_Attributes_Trait;

    public function __construct($product = 0)
    {        
        parent::__construct($product);
        if(isset($GLOBALS['tw_supplier_informations']) && count($GLOBALS['tw_supplier_informations']) > 0) {
            foreach($GLOBALS['tw_supplier_informations'] as $info_key => $info_value) {
                $this->data[$info_key] = '';
            }
        }
        $this->data['stock_management_mode'] = '';
        $this->data['stock_management_url'] = '';
        $this->data['delivery_methods'] = [];
    
        $this->_prefill_custom_attributes_with_default_value();
        $this->loadCustomAttributes($this->get_id());
        $this->loadCustomTaxonomy($this->get_id());
        do_action('tw_product_simple_new', $this);
    }

    /**
     * do_action( 'woocommerce_after_' . $this->object_type . '_object_save', $this, $this->data_store);
     */
    public function validate_props() {
		if(!empty($this->get_stock_management_mode()) && $this->get_stock_management_mode() != "dedicated_stock_managed_by_woocommerce"){
			$this->set_manage_stock(1);
		}

		parent::validate_props();

		if(!empty($this->get_stock_management_mode()) && $this->get_stock_management_mode() != "dedicated_stock_managed_by_woocommerce"){
			$this->set_manage_stock(0);
		}
	}

    public function set_image_id($image_id = '') {
        $gallery_ids = $this->get_gallery_image_ids('edit');

        if(!empty($image_id) && count($gallery_ids) == 0){
            parent::set_gallery_image_ids([$image_id]);
        }
        parent::set_image_id($image_id);
    }
}