<?php

defined( 'ABSPATH' ) || exit;

class TW_Order_Item_Product extends WC_Order_Item_Product {
    private $shipped_quantity = null;
    private $quantity_to_ship = null;

    public function set_shipped_quantity($shipped_quantity)
    {
        $this->shipped_quantity = $shipped_quantity;
    }

    public function get_shipped_quantity() : ?int
    {
        return $this->shipped_quantity;
    }

    public function set_quantity_to_ship($new_quantity)
    {
        $this->quantity_to_ship = $new_quantity;
    }

    public function get_quantity_to_ship() : ?int
    {
        return $this->quantity_to_ship;
    }

    public function convert_to_number($value) {
        if (is_numeric($value)) {
            if (strpos($value, '.') !== false) {
                return (float) $value;
            } else {
                return (int) $value;
            }
        }
        
        return null;
    }

    public function get_stock_available()
    {
        $product = $this->get_product();
        $availableQuantity = $product->get_stock_quantity() !== null ? $product->get_stock_quantity() : 0;
        if(!empty($product->get_stock_management_mode()) && $product->get_stock_management_mode() != "dedicated_stock_managed_by_woocommerce"){
            $stocks = TW_External_Stock_Manager::getInstance()->getProductStocks([$product], true);
            $availableQuantity = isset($stocks[$product->get_id()]) ? $stocks[$product->get_id()] : 0;
        }

        $reducedStock = $this->get_meta('_reduced_stock', true);
        if($product->get_stock_management_mode() != "dedicated_stock_managed_by_woocommerce" && !empty($reducedStock) && filter_var($reducedStock, FILTER_VALIDATE_INT) !== false){
            $availableQuantity = $availableQuantity + (int)$reducedStock;
        }
        return $availableQuantity;
    }

    public function has_enough_quantity_for_shipment($quantity)
    {
        $availableQuantity = $this->get_stock_available();
        return $availableQuantity > $quantity;
    }
}