<?php

class TW_Node {
    public $level = 1;
    public $nodes = [];
    public $data = [];
    public $parent = null;

    public $dataToProcess = null;
    public $processed = true;

    public function addNode(TW_Node $node)
    {
        $this->nodes[] = $node;
    }

    public function getNodesToProcess()
    {
        $nodesToProcess = [];
        foreach($this->nodes as $node) {
            if($node->processed == false) {
                $nodesToProcess[] = $node;
            }
        }

        return $nodesToProcess;
    }

    public function getAllChilds()
    {
        $childs = [];
        $currentNodes = $this->nodes;

        while(!empty($currentNodes)){
            $nodeToIterrate = [];
            foreach($currentNodes as $node) {
                
                $innerData = $node->data;
                if(!empty($innerData)){
                    $innerDataKeys = array_keys($innerData);
                    if(filter_var($innerDataKeys[0], FILTER_VALIDATE_INT) !== false){
                        foreach($innerData as $data){
                            $childs[] = $data;
                        }
                    } else {
                        $childs[] = $node->data;
                    }
                }

                if(!empty($node->nodes)){
                    foreach($node->nodes as $subNode) {
                        $nodeToIterrate[] = $subNode;
                    }
                }
            }
            $currentNodes = $nodeToIterrate;
        }

        return $childs;
    }
}