<?php

defined( 'ABSPATH' ) || exit;

class TW_MetaLayout {
    private $_items = [];

    public function __construct($itemList = [])
    {
        foreach($itemList as $item) {
            $this->_items[] = $item;
        }
    }

    public function getItems()
    {
        return $this->_items;
    }
}

class TW_MetaRow extends TW_MetaLayout {}

function tw_metabox_row()
{
    $rows = func_get_args();
    return new TW_MetaRow($rows);
}

class TW_MetaBox {
    public static function getAttachmentType($fieldType) {
        $attachmentType = "";
        if($fieldType == "image") {
            $attachmentType = "image";
        } else if($fieldType == "pdf") {
            $attachmentType = "application/pdf";
        }

        return $attachmentType;
    }

    public static function nonceDefinition($meta_box_key) {
        $nonce_name = $meta_box_key . '_nonce';
        $nonce_phrase = wp_hash($meta_box_key, "nonce");

        return [$nonce_name, $nonce_phrase];
    }

    public static function render($box_detail, $object = null) {
        $tw_metas = $GLOBALS['tw_metas'];
        $tw_metas = apply_filters('tw_metas', $tw_metas);

        $tw_taxonomies = $GLOBALS['tw_taxonomies'];

        $box_detail = $box_detail['args'];
        $boxType = $box_detail['box_type'];
        $boxId = $box_detail['box_id'];

        list($nonce_name, $nonce_phrase) = self::nonceDefinition($box_detail['box_id']);

        $metadata = [];
        if($object !== null) {
            if(in_array($box_detail['object_type'], array('post', 'user'))){
                $object_id = $object->ID; 
            } else {
                if($box_detail['object_type'] == 'comment') {
                    $object_id = $object->comment_ID; 
                } else if($box_detail['object_type'] == 'term') {
                    $object_id = $object->term_id;
                } else {
                    if(property_exists($object, 'ID')){
                        $object_id = $object->ID;
                    } else {
                        throw new \Exception("not implemented");
                    }
                }
            }
            $metadata = get_metadata($box_detail['object_type'], $object_id);
        }



        $output = '<div class="form-table tw-meta-table">';

        foreach($box_detail['fields'] as $field) {
            if(is_string($field)){
                $matching_meta_definition = isset($tw_metas[$boxType][$field]['metabox_field']) ? $tw_metas[$boxType][$field]['metabox_field'] : null;
                $matching_taxonomy_definition = isset($tw_taxonomies[$boxType][$field]) ? $tw_taxonomies[$boxType][$field] : null;

                if($matching_meta_definition === null && $matching_taxonomy_definition === null) {
                    throw new \Exception("UNABLE TO FIND FIELD FROM METABOX : " . $boxType . " " . $boxId);
                } else {
                    if($matching_meta_definition !== null) {
                        $matching_meta_definition['name'] = $field;
                        $output .= '<div class="tw-meta-row">';
                        $output .= self::_renderMetaField($matching_meta_definition, $metadata);
                        $output .= '</div>';
                    } else if($matching_taxonomy_definition !== null) {
                        $output .= '<div class="tw-meta-row">';
                        $output .= self::_renderTaxonomyField($field, $object);
                        $output .= '</div>';
                    }
                }
            } else if($field instanceof TW_MetaRow){
                $output .= '<div class="tw-meta-row">';
                foreach($field->getItems() as $item) {
                    $matching_meta_definition = isset($tw_metas[$boxType][$item]['metabox_field']) ? $tw_metas[$boxType][$item]['metabox_field'] : null;
                    $matching_taxonomy_definition = isset($tw_taxonomies[$boxType][$item]) ? $tw_taxonomies[$boxType][$item] : null;

                    if($matching_meta_definition === null && $matching_taxonomy_definition === null) {
                        throw new \Exception("UNABLE TO FIND FIELD FROM METABOX : " . $boxType . " " . $boxId);
                    } else {
                        if($matching_meta_definition !== null) {
                            $matching_meta_definition['name'] = $item;
                            $output .= self::_renderMetaField($matching_meta_definition, $metadata);
                        } else if($matching_taxonomy_definition !== null){
                            $output .= self::_renderTaxonomyField($item, $object);
                        }
                    }
                }
                $output .= '</div>';
            }
        }

        $output .= '</div>';
        wp_nonce_field($nonce_phrase, $nonce_name);

        echo $output;
    }

    private static function _renderTaxonomyField($taxonomyName, $object) {
        $row = '<div class="tw-meta-column">';
        ob_start();
        post_tags_meta_box($object, [
            'args' => [
                'taxonomy' => $taxonomyName,
                '__back_compat_meta_box' => true,
            ]
        ]);
        $row .= ob_get_contents();
        ob_end_clean();
        $row .= '</div>';
        return $row;
    }

     /**
      * description à coté du nom du champ
      * 2 champs cote à cote (flexbox)
      *
      * fichiers
      * wyswig avec tinymce
      *
      * nestedmetabox with objects or collection of object ?
      * ex (prochaines réunions)
      *   prochaines réunions
      *  dates
      *  salles

      *  //validation imbriqué
      *  meta prochaine_reunions [
      *      {date:'', salle:''}
      *  ]

      * le formulaire doit ressembler à ça, attention à la relecture des champs sérialisés
      *  $_POST['reunion'][0]['detail']['date'] = 
      *  $_POST['reunion'][1]['detail']['salle'] = 

      * tout le contenu du champs $_POST['reunion'] va être sérialisé par la suite
      */
     private static function _renderMetaField($field, $metadata) {
        $row = '<div class="tw-meta-column">';
        $value = isset($metadata[$field['name']]) ? $metadata[$field['name']][0] : "";
        
        if($field['field_type'] == "text") {
            $row .= '<div class="tw-meta-label"><label for="' . $field['name'] . '">' . $field['display_name'] . '</label>';
            if(isset($field['description'])) {
                $row .= '<span class="tw-meta-description">' . $field['description'] . '</span>';
            }
            $row .= '</div>';

            $row .= '<div class="tw-meta-content"><input class="tw_input" type="text" name="' . esc_attr($field['name']) .'" id="' . esc_attr($field['name']) .'" value="' . esc_attr($value) . '"/></div>';
        } else if($field['field_type'] == "number") {
            $row .= '<div class="tw-meta-label"><label for="' . $field['name'] . '">' . $field['display_name'] . '</label>';
            if(isset($field['description'])) {
                $row .= '<span class="tw-meta-description">' . $field['description'] . '</span>';
            }
            $row .= '</div>';
            
            $row .= '<div class="tw-meta-content"><input class="tw_input" type="number" name="' . esc_attr($field['name']) .'" id="' . esc_attr($field['name']) .'" value="' . esc_attr($value) . '"/></div>';
        } else if($field['field_type'] == "textarea") {
            $row .= '<div class="tw-meta-label"><label for="' . $field['name'] . '">' . $field['display_name'] . '</label>';
            if(isset($field['description'])) {
                $row .= '<span class="tw-meta-description">' . $field['description'] . '</span>';
            }
            $row .= '</div>';

            $row .= '<div class="tw-meta-content"><textarea class="tw_input" rows="4" name="' . esc_attr($field['name']) .'" id="' . esc_attr($field['name']) .'">' . esc_textarea($value) . '</textarea></div>';
        } else if($field['field_type'] == 'wysiwyg') { 
            $row .= '<div class="tw-meta-label"><label for="' . $field['name'] . '">' . $field['display_name'] . '</label>';
            if(isset($field['description'])) {
                $row .= '<span class="tw-meta-description">' . $field['description'] . '</span>';
            }
            $row .= '</div>';

            $row .= '<div class="tw-meta-content"><textarea class="tw_input tw_wysiwyg" rows="4" name="' . esc_attr($field['name']) .'" id="' . esc_attr($field['name']) .'">' . esc_textarea($value) . '</textarea></div>';
        } else if($field['field_type'] == "select") {
            $row .= '<div class="tw-meta-label"><label for="' . esc_attr($field['name']) . '">' . $field['display_name'] . '</label>';
            if(isset($field['description'])) {
                $row .= '<span class="tw-meta-description">' . $field['description'] . '</span>';
            }
            $row .= '</div>';

            $row .= '<div class="tw-meta-content">';
            $row .= '<select class="tw_input" id="' . esc_attr($field['name']) . '" name="' . esc_attr($field['name']) . '">';
            
            foreach($field['field_option'] as $option_key => $option_display) {
                if($option_key == $value) {
                    $row .= '<option selected="selected" value="' . esc_attr($option_key) . '">' . esc_html($option_display) . '</option>';
                } else {
                    $row .= '<option value="' . esc_attr($option_key) . '">' . esc_html($option_display) . '</option>';
                }
            }
            $row .= '</select>';
            $row .= '</div>';
        } else if($field['field_type'] == "checkbox") {
            $row .= '<div class="tw-meta-label"><label for="' . $field['name'] . '">' . $field['display_name'] . '</label>';
            if(isset($field['description'])) {
                $row .= '<span class="tw-meta-description">' . $field['description'] . '</span>';
            }
            $row .= '</div>';

            if($field['field_value'] == $value) {
                $row .= '<div class="tw-meta-content"><input id="' . esc_attr($field['name']) . '" name="' . esc_attr($field['name']) . '" type="checkbox" checked="checked" value="' . esc_attr($field['field_value']) . '"/></div>';
            } else {
                $row .= '<div class="tw-meta-content"><input id="' . esc_attr($field['name']) . '" name="' . esc_attr($field['name']) . '"  type="checkbox" value="' . esc_attr($field['field_value']) . '"/></div>';
            }
        } else if($field['field_type'] == "radio") {
            $row .= '<div class="tw-meta-label"><label for="' . $field['name'] . '">' . $field['display_name'] . '</label>';
            if(isset($field['description'])) {
                $row .= '<span class="tw-meta-description">' . $field['description'] . '</span>';
            }
            $row .= '</div>';

            foreach($field['field_option'] as $option_key => $option_display) {
                $row .= '<div class="tw-meta-content">';
                if ($option_key == $value) {
                    $row .= '<input checked="checked" type="radio" id="' . esc_attr($field['name']) . '_' . esc_attr($option_key) . '" name="' . esc_attr($field['name']) . '" value="' . esc_attr($option_key) . '"/>';   
                } else {
                    $row .= '<input type="radio" id="' . esc_attr($field['name']) . '_' . esc_attr($option_key) . '" name="' . esc_attr($field['name']) . '" value="' . esc_attr($option_key) . '"/>';  
                }
                $row .= '<label for="' . esc_attr($field['name']) . '_' . esc_attr($option_key) . '" >' . esc_attr($option_display) . '</label>';
                $row .= '</div>';
            }
        } else if(in_array($field['field_type'], array('image', 'pdf')) && (!isset($field['multiple']) || $field['multiple'] == false)) {
            $image_url = null;
            $preview_url = null;
            
            $row .= '<div class="tw-meta-label"><label for="' . $field['name'] . '">' . $field['display_name'] . '</label>';
            if(isset($field['description'])) {
                $row .= '<span class="tw-meta-description">' . $field['description'] . '</span>';
            }
            $row .= '</div>';

            $row .= '<div class="tw-meta-content">';
            $row .= '<ul data-type="' . self::getAttachmentType($field['field_type']) . '" class="tw-gallery">';

            if($field['field_type'] == 'image' && trim($value) != "") {
                $image_url = wp_get_attachment_image_url($value, array(80, 80));
            } else if(trim($value) != ""){
                $document = get_post($value);
            }

            if(isset($value) && trim($value) != ""){
                if($image_url !== null) {
                    $row .= '<li data-preview-type="image" data-id="' . trim($value) . '">';
                    $row .= '<span class="preview" style="background-image:url(\'' . $image_url . '\')"></span>';
                    $row .= '<a data-href="" class="tw-gallery-remove">&times;</a>';
                    $row .= '</li>';
                } else {
                    $row .= '<li data-preview-type="document" data-id="' . trim($value) . '">';
                    $row .= '<span data-preview-type="document" class="preview"></span>';
                    $row .= '<a data-href="" class="tw-gallery-remove">&times;</a>';
                    $row .= '<span class="documentName">' .  $document->post_title . '</span>';
                    $row .= '</li>';
                }
            }
            
            $row .= '</ul>';
            $row .= '<input type="hidden" id="' . esc_attr($field['name']) . '" name="' . esc_attr($field['name']) . '" value="' . esc_attr($value) . '"/>';
            
            if($field['field_type'] == 'image') {
                $row .= '<a class="button tw-gallery-add">' . __('Ajouter Image', 'tw') . '</a>';
            } else {
                $row .= '<a class="button tw-gallery-add">' . __('Ajouter Document', 'tw') . '</a>';
            }
            $row .= '</div>';
        } else if(in_array($field['field_type'], array('image', 'pdf')) && isset($field['multiple']) && $field['multiple'] == true) {
            $attachment_ids = $value == "" ? [] : explode(",", $value);

            $row .= '<div class="tw-meta-label"><label for="' . $field['name'] . '">' . $field['display_name'] . '</label>';
            if(isset($field['description'])) {
                $row .= '<span class="tw-meta-description">' . $field['description'] . '</span>';
            }
            $row .= '</div>';

            $row .= '<div class="tw-meta-content">';
            $row .= '<ul data-type="' . self::getAttachmentType($field['field_type']) . '" class="tw-gallery-multiple">';

            foreach($attachment_ids as $i => &$id) {
                if($field['field_type'] == 'image') {
                    $image_url = wp_get_attachment_image_url( $id, array( 80, 80 ));
                    $row .= '<li data-preview-type="image" data-id="' . $id . '">';
                    $row .= '<span class="preview" style="background-image:url(\'' . $image_url . '\')"></span>';
                    $row .= '<a data-href="" class="tw-gallery-multiple-remove">&times;</a>';
                    $row .= '</li>';
                } else {
                    $document = get_post($id);

                    $row .= '<li data-preview-type="document" data-id="' . trim($id) . '">';
                    $row .= '<span data-preview-type="document" class="preview"></span>';
                    $row .= '<a data-href="" class="tw-gallery-multiple-remove">&times;</a>';
                    $row .= '<span class="documentName">' . $document->post_title . '</span>'; 
                    $row .= '</li>';
                }
            }

            $row .= '</ul>';
            $row .= '<input type="hidden" id="' . esc_attr($field['name']) . '" name="' . esc_attr($field['name']) . '" value="' . esc_attr(join(',', $attachment_ids)) . '"/>';
            
            if($field['field_type'] == 'image') {
                $row .= '<a class="button tw-gallery-multiple-add">' . __('Ajouter Image(s)', 'tw') . '</a>';
            } else {
                $row .= '<a class="button tw-gallery-multiple-add">' . __('Ajouter Document(s)', 'tw') . '</a>';
            }
            $row .= '</div>';
        } else if($field['field_type'] == "date") {
            $row .= '<div class="tw-meta-label"><label for="' . $field['name'] . '">' . $field['display_name'] . '</label>';
            if(isset($field['description'])) {
                $row .= '<span class="tw-meta-description">' . $field['description'] . '</span>';
            }
            $row .= '</div>';

            $row .= '<div class="tw-meta-content">';
            $row .= '<div class="tw_input tw_date_container">';
            $row .= '<li data-keywords="calendar alt" data-code="f508" class="dashicons dashicons-calendar-alt" style=""></li>';
            $row .= '<input class="tw_date" type="text" value=""/>';
            $row .= '<input class="tw_date_hidden_input" type="hidden" name="' . esc_attr($field['name']) .'" id="' . esc_attr($field['name']) .'" value="' . esc_attr($value) . '"/>';
            $row .= '</div>';
            $row .= '</div>';
        }

        $row .= '</div>';

        $row = apply_filters('tw_metas_field', $row);
        return $row;
    }
}