<?php

defined( 'ABSPATH' ) || exit;

trait TW_Attributes_Trait {
    private $_cacheCustomAttributes = [];
    private $_cacheCustomTaxonomies = [];

    public function get_tw_default_attributes(){
        $tw_default_attributes = [];
        if(isset($GLOBALS['tw_product_default_attributes'])) {
            foreach($GLOBALS['tw_product_default_attributes'] as $attr_key => $attr_value) {
                $attribute = new WC_Product_Attribute();
                $attribute->set_id(0);
                $attribute->set_name($attr_key);
                $attribute->set_options(wc_get_text_attributes($attr_value['value']));
                $attribute->set_position($attr_value['position']);
                $attribute->set_visible($attr_value['is_visible']);
                $attribute->set_variation($attr_value['is_variation']);
                $tw_default_attributes[$attr_key] = $attribute;
            }
        }
        
        return $tw_default_attributes;
    }

    protected function _prefill_custom_attributes_with_default_value()
    {
        $tw_default_attributes = $this->get_tw_default_attributes();
        $setted_attributes = $this->get_attributes('edit');

        $setted_attributes_keys = [];
        foreach($setted_attributes as $key => $attr) {
            if($attr !== null) {
                $setted_attributes_keys[] = $key;
            }
        }

        $diff = array_diff(array_keys($tw_default_attributes), $setted_attributes_keys);
        foreach($diff as $missing_attribute_key) {
            $setted_attributes[$missing_attribute_key] = $tw_default_attributes[$missing_attribute_key];
        }
        uasort($setted_attributes, 'wc_product_attribute_uasort_comparison');
        $this->set_prop('attributes', $setted_attributes);
    }

    public function loadCustomAttributes($product_id){
        $custom_attributes = TW_Factory::getInstance()->getClass(TW_Product_Repository::class)->loadCustomAttributes($product_id);
        $this->_cacheCustomAttributes = $custom_attributes;
    }

    public function loadCustomTaxonomy($product_id){
        $custom_taxonomies = TW_Factory::getInstance()->getClass(TW_Product_Repository::class)->loadCustomTaxonomy($product_id);
        $this->_cacheCustomTaxonomies = $custom_taxonomies;
    }

    public function getCustomAttributesOrTaxonomy($attributeOrTaxonomy, $outputTaxonomyMode = "NAME"){
        $value = "";
        
        if(isset($this->_cacheCustomAttributes[$attributeOrTaxonomy])){
            $value = $this->_cacheCustomAttributes[$attributeOrTaxonomy];
        } else if(isset($this->_cacheCustomTaxonomies[$attributeOrTaxonomy])){
            $values = [];
            foreach($this->_cacheCustomTaxonomies[$attributeOrTaxonomy] as $taxName => $taxDetail) {
                if($outputTaxonomyMode == "ID") {
                    $values[] = $taxDetail['term_id'];
                } else if ($outputTaxonomyMode == "NAME") {
                    $values[] = $taxDetail['name'];
                } else if ($outputTaxonomyMode == "SLUG") {
                    $values[] = $taxDetail['slug'];
                }
            }
            $value = $values;
        }
        return $value;
    }

    public function set_attributes($raw_attributes){
        parent::set_attributes($raw_attributes);
        $this->_prefill_custom_attributes_with_default_value();
    }
}