<?php

namespace CleantalkSP\SpbctWP\Scanner\ScanningLog;

class Template
{
    /**
     * Render the scanning log
     *
     * @param array $data
     * @param int $offset
     * @return string
     */
    public static function render($data, $offset)
    {
        $template = '<div id="spbcscan-results-log-module">';
        $template .= '<div class="panel-body">';

        $template .= self::generateRows($data);

        $template .= '</div>';
        $template .= '</div>';
        $template .= '<div class="spbc_log-pagination">';
        $template .= '<button id="spbc_load_more_scan_logs" class="spbc_manual_link" data-offset="' . $offset . '">'
                     . __('Load more logs', 'security-malware-firewall')
                     . '</button>';
        $template .= '</div>';

        return $template;
    }

    public static function generateRows($data)
    {
        global $spbc;

        $template = '';
        $prev_item_content = '';

        foreach ($data as $item) {
            if ($prev_item_content === $item['content']) {
                continue;
            }

            $template .= '<p class="spbc_log-line">'
                         . date("M d Y H:i:s", $item['timestamp'] + $spbc->data['site_utc_offset_in_seconds'])
                         . ' '
                         . wp_kses($item['content'], ['b' => array()])
                         . '</p>';

            $prev_item_content = $item['content'];
        }

        return $template;
    }
}
