<?php

namespace CleantalkSP\SpbctWP\Scanner\OSCron\View;

use CleantalkSP\Templates\Singleton;

class OSCronLocale
{
    use Singleton;

    public $task__status_enabled;
    public $task__status_disabled;
    public $task__status_critical;
    public $task__verdict_critical;
    public $task__verdict_checked;
    public $no_windows_support;
    public $error__load_cron_storage;
    public $error__load_env_cron;
    public $error__invalid_arg;
    public $error__missing_property;
    public $error__invalid_cron_expression;
    public $error__task_not_found;
    public $controller__task_approved;
    public $controller__task_disabled;
    public $action__disable_task;
    public $action__enable_task;
    public $settings__accordion_tab_description;
    public $settings__option_title;
    public $settings__option_description;
    public $malware_removal_banner_text;
    public $task__nothing_detected;

    public function init()
    {
        $this->task__status_enabled  = __('Enabled', 'security-malware-firewall');
        $this->task__status_disabled = __('Disabled', 'security-malware-firewall');
        $this->task__status_critical = __('Critical', 'security-malware-firewall');
        $this->task__verdict_critical = __('Critical', 'security-malware-firewall');
        $this->task__verdict_checked = __('Checked', 'security-malware-firewall');
        $this->task__nothing_detected = __('None', 'security-malware-firewall');
        $this->action__disable_task = __('Disable', 'security-malware-firewall');
        $this->action__enable_task = __('Enable', 'security-malware-firewall');
        $this->no_windows_support = __('Windows OS cron handling is not supported.', 'security-malware-firewall');
        $this->controller__task_approved = __('Task has been enabled.', 'security-malware-firewall');
        $this->controller__task_disabled = __('Task has been disabled.', 'security-malware-firewall');
        $this->error__load_cron_storage = __('Storage: Cannot load cron', 'security-malware-firewall');
        $this->error__load_env_cron = __('Environment: Cannot load cron', 'security-malware-firewall');
        $this->error__invalid_arg = __('invalid argument', 'security-malware-firewall');
        $this->error__missing_property = __('property is no set', 'security-malware-firewall');
        $this->error__invalid_cron_expression = __('Invalid cron expression', 'security-malware-firewall');
        $this->error__task_not_found = __('Task tried to update is not found', 'security-malware-firewall');
        $this->settings__accordion_tab_description = __('This section provides an overview of scheduled cron jobs on server that perform automated tasks. Check your cron jobs for suspicious entries and delete or modify entries.', 'security-malware-firewall');
        $this->settings__option_title = __('Operating system cron tasks analysis', 'security-malware-firewall');
        $this->settings__option_description = __('This functional provides an overview of scheduled cron jobs on server that perform automated tasks.', 'security-malware-firewall');
        $this->malware_removal_banner_text = __('There is a high probability that your website has been compromised, suspicious operating system CRON tasks has been detected. Take action now by ordering malware removal from our experienced security specialists.', 'security-malware-firewall');
    }
}
