<?php

namespace CleantalkSP\SpbctWP\Scanner\CureLog;

use CleantalkSP\Templates\DTO;

class CureLogRecord extends DTO
{
    /**
     * @var string
     */
    public $full_hash = '';

    /**
     * @var string
     */
    public $cured_hash;
    /**
     * @var string
     */
    public $fast_hash = '';
    /**
     * @var string
     */
    public $real_path = '';
    /**
     * @var int
     */
    public $cure_status = 0;
    /**
     * @var int
     */
    public $is_restored = 0;
    /**
     * @var string
     */
    public $weak_spots_cured = '';
    /**
     * @var string
     */
    public $weak_spots_uncured = '';
    /**
     * @var int
     */
    public $has_backup = 0;
    /**
     * @var int
     */
    public $cci_cured = 0;
    /**
     * @var string
     */
    public $fail_reason = '';
    /**
     * @var int
     */
    public $last_cure_date = 0;
    /**
     * @var string
     */
    public $scanner_start_local_date = '';
    /**
     * @var string
     * @psalm-suppress PossiblyUnusedProperty //todo if we decide to save heuristic re-check fails - we should use this property
     */
    public $heuristic_rescan_result = null;

    protected $obligatory_properties = [
        'fast_hash',
        'full_hash',
        'cured_hash',
        'real_path',
        'cure_status',
        'weak_spots_cured',
        'weak_spots_uncured',
        'cci_cured',
        'fail_reason',
        'last_cure_date',
        'scanner_start_local_date',
        'heuristic_rescan_result'
    ];

    public function __construct($data)
    {
        parent::__construct($data);
    }

    /**
     * @param $prop
     * @return array
     */
    public function getPropAsArray($prop = '')
    {
        if (is_string($prop) && isset($this->$prop) && is_string($this->$prop)) {
            $json = json_decode($this->$prop, true);
            if ($json !== false) {
                return $json;
            }
        }
        return array();
    }
}
